/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.payment;

import io.swagger.annotations.ApiModelProperty;
import java.util.Currency;
import java.util.Locale;
import java.util.ResourceBundle;

public class PriceModel {
    @ApiModelProperty(value="start time in minutes", dataType="java.lang.Integer", required=true, example="60")
    private Integer fromMinute;
    @ApiModelProperty(value="end time in minutes", dataType="java.lang.Integer", required=true, example="60")
    private Integer untilMinute;
    @ApiModelProperty(value="interval time in minutes, e.g. 50 cent per 30 minutes", dataType="java.lang.Integer", required=true, example="30")
    private Integer interval;
    @ApiModelProperty(value="price in cent", dataType="java.lang.Integer", required=true, example="50")
    private Integer priceInCent;
    @ApiModelProperty(value="priority, e.g. one price model could dominate another", dataType="java.lang.Integer", required=true, example="50")
    private Integer priority;
    @ApiModelProperty(value="textual description for special price models", dataType="java.lang.String", required=true, example="Tennisclub")
    private String description;
    @ApiModelProperty(value="maximal price in cent", dataType="java.lang.Integer", required=true, example="50")
    private Integer maxPriceInCent;
    @ApiModelProperty(value="currency", dataType="java.lang.String", required=true, example="EUR")
    private Currency currency;

    public PriceModel() {
        this.currency = Currency.getInstance("EUR");
    }

    public PriceModel(Integer fromMinute, Integer untilMinute, Integer interval, Integer priceInCent, Integer priority, String description, Integer maxPriceInCent, Currency currency) {
        this.fromMinute = fromMinute;
        this.untilMinute = untilMinute;
        this.interval = interval;
        this.priceInCent = priceInCent;
        this.priority = priority;
        this.description = description;
        this.maxPriceInCent = maxPriceInCent;
        this.currency = currency;
    }

    public Integer getFromMinute() {
        return this.fromMinute;
    }

    public void setFromMinute(Integer fromMinute) {
        this.fromMinute = fromMinute;
    }

    public Integer getUntilMinute() {
        return this.untilMinute;
    }

    public void setUntilMinute(Integer untilMinute) {
        this.untilMinute = untilMinute;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public Integer getPriceInCent() {
        return this.priceInCent;
    }

    public void setPriceInCent(Integer priceInCent) {
        this.priceInCent = priceInCent;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getMaxPriceInCent() {
        return this.maxPriceInCent;
    }

    public void setMaxPriceInCent(Integer maxPriceInCent) {
        this.maxPriceInCent = maxPriceInCent;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriceModel that = (PriceModel)o;
        if (this.fromMinute != null ? !this.fromMinute.equals(that.fromMinute) : that.fromMinute != null) {
            return false;
        }
        if (this.untilMinute != null ? !this.untilMinute.equals(that.untilMinute) : that.untilMinute != null) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) {
            return false;
        }
        if (this.priceInCent != null ? !this.priceInCent.equals(that.priceInCent) : that.priceInCent != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        return this.description != null ? this.description.equals(that.description) : that.description == null;
    }

    public int hashCode() {
        int result = this.fromMinute != null ? this.fromMinute.hashCode() : 0;
        result = 31 * result + (this.untilMinute != null ? this.untilMinute.hashCode() : 0);
        result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
        result = 31 * result + (this.priceInCent != null ? this.priceInCent.hashCode() : 0);
        result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        if ((this.priceInCent == null || this.priceInCent == -1) && this.maxPriceInCent == null) {
            result = result + bundle.getString("withCosts");
        } else if (this.priceInCent != null && this.priceInCent != -1) {
            result = result + this.getCurrencyAsString(this.priceInCent);
        }
        if (this.maxPriceInCent != null) {
            result = result + bundle.getString("maximal") + " " + this.getCurrencyAsString(this.maxPriceInCent);
        }
        if (this.interval != null) {
            result = result + bundle.getString("inIntervalOf") + " " + this.getTimeString(this.interval, bundle, true);
        }
        if (this.fromMinute != null && this.fromMinute > 0) {
            result = this.untilMinute != null ? result + " " : result + " " + bundle.getString("from") + " ";
            result = result + this.getTimeString(this.fromMinute, bundle, false);
        }
        if (this.untilMinute != null) {
            result = result + " " + bundle.getString("until") + " " + this.getTimeString(this.untilMinute, bundle, false);
        }
        if (this.description != null) {
            result = result + " " + this.description;
        }
        result = result.trim();
        return result;
    }

    private String getTimeString(Integer minute, ResourceBundle bundle, boolean isInterval) {
        int days = (int)Math.floor(minute / 60 / 24);
        int hours = minute / 60 % 24;
        int minutes = minute % 60;
        String time = "";
        if (days > 0) {
            time = days == 1 ? (isInterval ? bundle.getString("day") + " " : bundle.getString("oneDay") + " ") : days + " " + bundle.getString("days") + " ";
        }
        if (hours > 0) {
            String hourString = "";
            if (!time.isEmpty()) {
                hourString = hourString + bundle.getString("and") + " ";
            }
            hourString = hours == 1 ? (isInterval ? hourString + bundle.getString("hour") + " " : hourString + bundle.getString("oneHour") + " ") : hourString + hours + " " + bundle.getString("hours") + " ";
            time = time + hourString;
        }
        if (minutes > 0) {
            String minuteString = "";
            if (!time.isEmpty()) {
                minuteString = minuteString + bundle.getString("and") + " ";
            }
            minuteString = minutes == 1 ? (isInterval ? minuteString + bundle.getString("minute") + " " : minuteString + bundle.getString("oneMinute") + " ") : minuteString + minutes + " " + bundle.getString("minutes") + " ";
            time = time + minuteString;
        }
        time = time.trim();
        return time;
    }

    @Deprecated
    protected String getCurrenceAsString(Integer priceInCent) {
        return this.getCurrencyAsString(priceInCent);
    }

    protected String getCurrencyAsString(Integer priceInCent) {
        int euro = priceInCent / 100;
        int cent = priceInCent % 100;
        String centString = "" + cent;
        if (cent < 10) {
            centString = "0" + centString;
        }
        return euro + "," + centString + this.currency.getSymbol(Locale.getDefault()) + " ";
    }
}

