/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.parkingarea;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.aipark.api.chargingstation.ChargingPlugType;
import de.aipark.api.parkingarea.EntrancePoint;
import de.aipark.api.parkingarea.MapEntry;
import de.aipark.api.parkingarea.OpeningStatus;
import de.aipark.api.parkingarea.ParkingAreaType;
import de.aipark.api.parkingarea.Schedule;
import de.aipark.api.payment.PriceModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ParkingArea {
    @ApiModelProperty(value="name of parking area", dataType="java.lang.String", required=true, example="Rathaus")
    private String name;
    @ApiModelProperty(value="shape of parking area, e.g. multipolygon for areas or line for on street parking", required=true)
    private Geometry shape;
    @ApiModelProperty(value="center point of parking area", required=true)
    private Point center;
    @ApiModelProperty(value="capacity of parking area (number of spots)", dataType="java.lang.Integer", required=true, example="100")
    private Integer capacity;
    @ApiModelProperty(value="type of parking area, types getting added in the future", dataType="de.aipark.api.parkingarea.ParkingAreaType", required=true, example="ON_STREET")
    private String parkingAreaType;
    @ApiModelProperty(value="unique id of parking area", dataType="java.lang.Long", required=true, example="504838")
    private Long id;
    @ApiModelProperty(value="value=null indicates no information about capacity designated for disabled, value>0 indicates number of spots designated for women, value=0 indicates no special capacity for women, value=-1 indicates that there are spots designated for women but capacity is unknown", dataType="java.lang.Integer", example="10")
    private Integer capacityWoman;
    @ApiModelProperty(value="value=null indicates no information about capacity designated for disabled, value>0 indicates number of spots designated for disabled, value=0 indicates no special capacity for disabled, value=-1 indicates that there are spots designated for disabled but capacity is unknown", dataType="java.lang.Integer", example="10")
    private Integer capacityDisabled;
    @ApiModelProperty(value="schedule when parking area is opened or closed", dataType="MapEntry<Schedule, Boolean>")
    private MapEntry<Schedule, OpeningStatus> scheduleOpen;
    @ApiModelProperty(value="schedule for parking disc (value = allowed time in minutes)", dataType="MapEntry<Schedule, Boolean>")
    private MapEntry<Schedule, Integer> scheduleMaxStay;
    @ApiModelProperty(value="price model mapping", dataType="MapEntry<Schedule, PriceModel>")
    private MapEntry<Schedule, PriceModel> schedulePriceModel;
    @ApiModelProperty(value="schedule with capacity of parking area (number of spots) for residential parking only", dataType="MapEntry<Schedule, Integer>")
    private MapEntry<Schedule, Integer> scheduleResidential;
    @ApiModelProperty(value="entrance point for parking area", dataType="List<EntrancePoint>")
    private List<EntrancePoint> entrancePoints;
    @ApiModelProperty(value="mapping of charging plug type to number of plugs with this type", dataType="MapEntry<ChargingPlugType,Integer>")
    private MapEntry<ChargingPlugType, Integer> chargingPlugTypes;

    public ParkingArea() {
        this.scheduleOpen = new MapEntry();
        this.scheduleMaxStay = new MapEntry();
        this.schedulePriceModel = new MapEntry();
        this.scheduleResidential = new MapEntry();
        this.entrancePoints = new ArrayList<EntrancePoint>();
        this.chargingPlugTypes = new MapEntry();
    }

    public ParkingArea(String name, Geometry shape, Point center, Integer capacity, String parkingAreaType, Long id, Integer capacityWoman, Integer capacityDisabled, MapEntry<Schedule, OpeningStatus> scheduleOpen, MapEntry<Schedule, Integer> scheduleMaxStay, MapEntry<Schedule, PriceModel> schedulePriceModel, MapEntry<Schedule, Integer> scheduleResidential, List<EntrancePoint> entrancePoints, MapEntry<ChargingPlugType, Integer> chargingPlugTypes) {
        this.name = name;
        this.shape = shape;
        this.center = center;
        this.capacity = capacity;
        this.parkingAreaType = parkingAreaType;
        this.id = id;
        this.capacityWoman = capacityWoman;
        this.capacityDisabled = capacityDisabled;
        this.scheduleOpen = scheduleOpen;
        this.scheduleMaxStay = scheduleMaxStay;
        this.schedulePriceModel = schedulePriceModel;
        this.scheduleResidential = scheduleResidential;
        this.entrancePoints = entrancePoints;
        this.chargingPlugTypes = chargingPlugTypes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Geometry getShape() {
        return this.shape;
    }

    public void setShape(Geometry shape) {
        this.shape = shape;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public ParkingAreaType getParkingAreaType() {
        try {
            return ParkingAreaType.valueOf(this.parkingAreaType);
        }
        catch (IllegalArgumentException e) {
            return ParkingAreaType.PARKINGAREA;
        }
    }

    public void setParkingAreaType(String parkingAreaType) {
        this.parkingAreaType = parkingAreaType;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getCapacityWoman() {
        return this.capacityWoman;
    }

    public void setCapacityWoman(Integer capacityWoman) {
        this.capacityWoman = capacityWoman;
    }

    public Integer getCapacityDisabled() {
        return this.capacityDisabled;
    }

    public void setCapacityDisabled(Integer capacityDisabled) {
        this.capacityDisabled = capacityDisabled;
    }

    public MapEntry<Schedule, OpeningStatus> getScheduleOpen() {
        return this.scheduleOpen;
    }

    public void setScheduleOpen(MapEntry<Schedule, OpeningStatus> scheduleOpen) {
        this.scheduleOpen = scheduleOpen;
    }

    public MapEntry<Schedule, Integer> getScheduleMaxStay() {
        return this.scheduleMaxStay;
    }

    public void setScheduleMaxStay(MapEntry<Schedule, Integer> scheduleMaxStay) {
        this.scheduleMaxStay = scheduleMaxStay;
    }

    public MapEntry<Schedule, PriceModel> getSchedulePriceModel() {
        return this.schedulePriceModel;
    }

    public void setSchedulePriceModel(MapEntry<Schedule, PriceModel> schedulePriceModel) {
        this.schedulePriceModel = schedulePriceModel;
    }

    public MapEntry<Schedule, Integer> getScheduleResidential() {
        return this.scheduleResidential;
    }

    public void setScheduleResidential(MapEntry<Schedule, Integer> scheduleResidential) {
        this.scheduleResidential = scheduleResidential;
    }

    public List<EntrancePoint> getEntrancePoints() {
        return this.entrancePoints;
    }

    public void setEntrancePoints(List<EntrancePoint> entrancePoints) {
        this.entrancePoints = entrancePoints;
    }

    public MapEntry<ChargingPlugType, Integer> getChargingPlugTypes() {
        return this.chargingPlugTypes;
    }

    public void setChargingPlugTypes(MapEntry<ChargingPlugType, Integer> chargingPlugTypes) {
        this.chargingPlugTypes = chargingPlugTypes;
    }

    public Point getCenter() {
        return this.center;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public String toString() {
        return "ParkingArea{name='" + this.name + '\'' + ", shape=" + this.shape + ", center=" + this.center + ", capacity=" + this.capacity + ", parkingAreaType=" + this.parkingAreaType + ", id=" + this.id + ", capacityWoman=" + this.capacityWoman + ", capacityDisabled=" + this.capacityDisabled + ", scheduleOpen=" + this.scheduleOpen + ", scheduleMaxStay=" + this.scheduleMaxStay + ", schedulePriceModel=" + this.schedulePriceModel + ", scheduleResidential=" + this.scheduleResidential + ", entrancePoints=" + this.entrancePoints + ", chargingPlugTypes=" + this.chargingPlugTypes + '}';
    }

    @JsonIgnore
    public String getPriceString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        HashMap<Schedule, ArrayList<PriceModel>> scheduleListMap = new HashMap<Schedule, ArrayList<PriceModel>>();
        for (MapEntry.Entry<Schedule, PriceModel> entry : this.schedulePriceModel.getEntryList()) {
            ArrayList<PriceModel> priceModels = (ArrayList<PriceModel>)scheduleListMap.get(entry.getKey());
            if (priceModels == null) {
                priceModels = new ArrayList<PriceModel>();
            }
            priceModels.add(entry.getValue());
            scheduleListMap.put(entry.getKey(), priceModels);
        }
        ArrayList schedules = new ArrayList(scheduleListMap.keySet());
        Collections.sort(schedules, new ScheduleComparator());
        boolean onlyDefaultPriceModels = false;
        for (Schedule schedule : schedules) {
            if (schedule.toString().isEmpty()) {
                if (schedules.size() > 1) {
                    result = result + bundle.getString("otherwise") + ":\n";
                } else {
                    onlyDefaultPriceModels = true;
                }
            } else {
                result = result + schedule.toString() + ":\n";
            }
            ArrayList priceModels = new ArrayList((Collection)scheduleListMap.get(schedule));
            Collections.sort(priceModels, new PriceModelComparator());
            boolean hasPeriodPricemodels = false;
            for (PriceModel priceModel : priceModels) {
                if (!onlyDefaultPriceModels) {
                    result = result + "\t";
                }
                if (priceModel.getFromMinute() != null || priceModel.getUntilMinute() != null) {
                    hasPeriodPricemodels = true;
                } else if (hasPeriodPricemodels && priceModel.getInterval() != null && priceModel.getMaxPriceInCent() == null) {
                    result = result + bundle.getString("otherwise") + " ";
                }
                result = result + priceModel.toString() + "\n";
            }
        }
        return result;
    }

    @JsonIgnore
    public String getMaxStayString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        for (MapEntry.Entry<Schedule, Integer> entry : this.scheduleMaxStay.getEntryList()) {
            if (!result.isEmpty()) {
                result = result + "\n";
            }
            result = result + entry.getKey().toString() + " " + bundle.getString("maximal") + " " + entry.getValue() + " " + bundle.getString("minutes");
        }
        return result;
    }

    private class PriceModelComparator
    implements Comparator<PriceModel> {
        private PriceModelComparator() {
        }

        @Override
        public int compare(PriceModel o1, PriceModel o2) {
            if (!(o1.getFromMinute() == null && o1.getUntilMinute() == null || o2.getFromMinute() != null && o2.getUntilMinute() != null)) {
                return -1;
            }
            if (!(o2.getFromMinute() == null && o2.getUntilMinute() == null || o1.getFromMinute() != null && o1.getUntilMinute() != null)) {
                return 1;
            }
            if (o1.getFromMinute() != null && o2.getFromMinute() != null) {
                return o1.getFromMinute() - o2.getFromMinute();
            }
            if (o1.getUntilMinute() != null && o2.getUntilMinute() != null) {
                return o1.getUntilMinute() - o2.getUntilMinute();
            }
            if (o1.getInterval() != null && o2.getInterval() != null) {
                return o1.getInterval() - o2.getInterval();
            }
            if (o1.getInterval() != null && o2.getInterval() == null) {
                return -1;
            }
            if (o1.getInterval() == null && o2.getInterval() != null) {
                return 1;
            }
            if (o1.getMaxPriceInCent() == null && o2.getMaxPriceInCent() != null) {
                return -1;
            }
            return 0;
        }
    }

    private class ScheduleComparator
    implements Comparator<Schedule> {
        private ScheduleComparator() {
        }

        @Override
        public int compare(Schedule o1, Schedule o2) {
            if (o1.toString().isEmpty()) {
                return 1;
            }
            if (o2.toString().isEmpty()) {
                return -1;
            }
            return o1.toString().length() - o2.toString().length();
        }
    }
}

