/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.parkingarea;

import java.util.ArrayList;
import java.util.List;

public class MapEntry<K, V> {
    private List<Entry<K, V>> entryList;

    public MapEntry() {
        this.entryList = new ArrayList<Entry<K, V>>();
    }

    public MapEntry(List<Entry<K, V>> entryListInstance) {
        this.entryList = entryListInstance;
    }

    public List<Entry<K, V>> getEntryList() {
        return this.entryList;
    }

    public void setEntryList(List<Entry<K, V>> entryList) {
        this.entryList = entryList;
    }

    public V findValueForKey(K key) {
        for (Entry<K, V> entry : this.entryList) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(MapEntry.class)) {
            return false;
        }
        MapEntry other = (MapEntry)obj;
        List<Entry<K, V>> otherList = other.getEntryList();
        return this.getEntryList().containsAll(otherList) && otherList.containsAll(this.entryList);
    }

    public int hashCode() {
        return this.entryList.hashCode();
    }

    public String toString() {
        return "MapEntry{entryList=" + this.entryList + '}';
    }

    public static class Entry<K, V> {
        private K key;
        private V value;

        public Entry() {
        }

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!obj.getClass().equals(Entry.class)) {
                return false;
            }
            Entry other = (Entry)obj;
            if (!this.key.getClass().equals(other.getKey().getClass())) {
                return false;
            }
            if (!this.value.getClass().equals(other.getValue().getClass())) {
                return false;
            }
            return this.key.equals(other.getKey()) && this.value.equals(other.getValue());
        }

        public int hashCode() {
            return (this.key + "" + this.value).hashCode();
        }

        public String toString() {
            return "Entry{key=" + this.key + ", value=" + this.value + '}';
        }
    }
}

