/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.chargingstation;

import de.aipark.api.chargingstation.ChargingPriceModel;
import de.aipark.api.parkingarea.Schedule;
import de.aipark.api.payment.PriceModel;
import java.util.Currency;
import java.util.ResourceBundle;

public class ChargingPriceEntry
extends PriceModel {
    private ChargingPriceModel model;
    private Schedule schedule;
    private Integer initialPrice;
    private Integer priceKW;

    public ChargingPriceEntry() {
    }

    public ChargingPriceEntry(Integer fromMinute, Integer untilMinute, Integer interval, Integer priceInCent, Integer priority, String description, Integer maxPriceInCent, Currency currency, ChargingPriceModel model, Schedule schedule, int initialPrice, int priceKW) {
        super(fromMinute, untilMinute, interval, priceInCent, priority, description, maxPriceInCent, currency);
        this.model = model;
        this.schedule = schedule;
        this.initialPrice = initialPrice;
        this.priceKW = priceKW;
    }

    public ChargingPriceModel getModel() {
        return this.model;
    }

    public void setModel(ChargingPriceModel model) {
        this.model = model;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public int getInitialPrice() {
        return this.initialPrice;
    }

    public void setInitialPrice(int initialPrice) {
        this.initialPrice = initialPrice;
    }

    public int getPriceKW() {
        return this.priceKW;
    }

    public void setPriceKW(int priceKW) {
        this.priceKW = priceKW;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChargingPriceEntry)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChargingPriceEntry that = (ChargingPriceEntry)o;
        if (this.getInitialPrice() != that.getInitialPrice()) {
            return false;
        }
        if (this.getPriceKW() != that.getPriceKW()) {
            return false;
        }
        if (this.getModel() != null ? !this.getModel().equals(that.getModel()) : that.getModel() != null) {
            return false;
        }
        return this.getSchedule() != null ? this.getSchedule().equals(that.getSchedule()) : that.getSchedule() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getModel() != null ? this.getModel().hashCode() : 0);
        result = 31 * result + (this.getSchedule() != null ? this.getSchedule().hashCode() : 0);
        result = 31 * result + this.getInitialPrice();
        result = 31 * result + this.getPriceKW();
        return result;
    }

    @Override
    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        if (this.schedule != null) {
            result = result + this.schedule.toString();
        }
        if (this.model != null) {
            if (!result.isEmpty()) {
                result = result + " ";
            }
            result = result + this.model.getName();
        }
        String priceString = "";
        if (this.initialPrice != null) {
            priceString = priceString + bundle.getString("initialPrice") + " " + this.getCurrencyAsString(this.initialPrice).trim();
        }
        if (this.priceKW != null) {
            if (!priceString.isEmpty()) {
                priceString = priceString + ", ";
            }
            priceString = priceString + this.getCurrencyAsString(this.initialPrice).trim() + bundle.getString("priceKW");
        }
        if (!super.toString().isEmpty()) {
            if (!priceString.isEmpty()) {
                priceString = priceString + ", ";
            }
            priceString = priceString + super.toString();
        }
        if (!priceString.isEmpty()) {
            if (!result.isEmpty()) {
                result = result + "\n\t";
            }
            result = result + priceString;
        }
        return result;
    }
}

