package de.aipark.api.webservice.jsonConverter.aiparkapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.aipark.api.chargingstation.ChargingPlugType;

import java.io.IOException;

/**
 * Created by torgen on 25.09.17.
 */
public class ChargingPlugTypeDeserializer extends KeyDeserializer {
    ObjectMapper objectMapper;

    public ChargingPlugTypeDeserializer() {
        objectMapper = new ObjectMapper();
    }

    @Override
    public ChargingPlugType deserializeKey(String key, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        try {
            return objectMapper.readValue(key,ChargingPlugType.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}
