package de.aipark.api.tile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by torgen on 15.06.17.
 */
public class Tile {
    @ApiModelProperty(value = "x value of slippy tile", dataType = "java.lang.Double", required = true, example = "17340")
    private double x;

    @ApiModelProperty(value = "y value of slippy tile", dataType = "java.lang.Double", required = true, example = "10785")
    private double y;

    @ApiModelProperty(value = "zoom level of slippy tile", dataType = "java.lang.Integer", required = true, example = "15")
    private int zoom;

    public Tile(double x, double y, int zoom) {
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    public Tile() {
    }

    public double getX() {
        return x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public int getZoom() {
        return zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    @Override
    public int hashCode() {
        String hashString = "x" + x + "y" + y + "zoom" + zoom;
        return hashString.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        Tile other = (Tile) obj;
        return x == other.x && y == other.y && zoom == other.zoom;
    }

    @JsonIgnore
    public Tile getRoundedTile(){
        return new Tile((int)x,(int)y,zoom);
    }

    @Override
    public String toString() {
        return "Tile{" +
                "x=" + x +
                ", y=" + y +
                ", zoom=" + zoom +
                '}';
    }
}

