package de.aipark.api.sdk.route;

import com.vividsolutions.jts.geom.Point;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by Andreas on 31.10.16
 */
@SuppressWarnings({"unused", "WeakerAccess"})
public class RoutePoint implements Serializable {

    private Long id;

    @ApiModelProperty(required = true, dataType = "java.lang.Long", example = "1480000979212")
    private Timestamp timestamp;

    @ApiModelProperty(required = true, example = "10.2")
    private Float speed;

    @ApiModelProperty(required = true, example = "8.5")
    private Float accuracy;

    @ApiModelProperty(required = true)
    private Point point;

    private String state;

    private Float bearing;

    private Float altitude;

    public RoutePoint() {
    }

    public RoutePoint(Timestamp timestamp, Point point, Float speed, Float accuracy) {
        this(-1l, timestamp, point, speed, accuracy);
    }

    public RoutePoint(Long id, Timestamp timestamp, Point point, Float speed, Float accuracy) {
        super();
        this.id = id;
        this.timestamp = timestamp;
        //update point with own GeometryFactory and precision (rounding of coordinates can be an issue in DB)
        this.point = point;
        this.speed = speed;
        this.accuracy = accuracy;
    }

    public RoutePoint(Long id, Timestamp timestamp, Point point, Float speed, Float accuracy, String state, Float bearing, Float altitude) {
        this.id = id;
        this.timestamp = timestamp;
        this.speed = speed;
        this.accuracy = accuracy;
        this.point = point;
        this.state = state;
        this.bearing = bearing;
        this.altitude = altitude;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Timestamp getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public Point getPoint() {
        return point;
    }

    public void setPoint(Point point) {
        //update point with own GeometryFactory and precision (rounding of coordinates can be an issue in DB)
        this.point = point;
    }

    public Float getSpeed() {
        return speed;
    }

    public void setSpeed(Float speed) {
        this.speed = speed;
    }

    public Float getAccuracy() {
        return accuracy;
    }

    public void setAccuracy(Float accuracy) {
        this.accuracy = accuracy;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Float getBearing() {
        return bearing;
    }

    public void setBearing(Float bearing) {
        this.bearing = bearing;
    }

    public Float getAltitude() {
        return altitude;
    }

    public void setAltitude(Float altitude) {
        this.altitude = altitude;
    }

    @Override
    public String toString() {
        return "RoutePoint{" +
                "id=" + id +
                ", timestamp=" + timestamp +
                ", speed=" + speed +
                ", accuracy=" + accuracy +
                ", point=" + point +
                ", state='" + state + '\'' +
                ", bearing=" + bearing +
                ", altitude=" + altitude +
                '}';
    }
}