package de.aipark.api.sdk.route;

import de.aipark.api.device.AppVersion;
import de.aipark.api.device.Device;
import de.aipark.api.device.OsVersion;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * Created by Andreas on 31.10.16
 */
@SuppressWarnings({"unused", "WeakerAccess"})
public class Route implements Serializable {

    private long id;

    @ApiModelProperty(required = true)
    private AppVersion appVersion;

    @ApiModelProperty(required = true)
    private OsVersion osVersion;

    @ApiModelProperty(required = true)
    private Device device;

    @ApiModelProperty(required = true)
    private List<RoutePoint> routePoints;

    public Route() {
    }

    public Route(AppVersion appVersion, OsVersion osVersion, Device device, List<RoutePoint> routePoints) {
        this.appVersion = appVersion;
        this.osVersion = osVersion;
        this.device = device;
        this.routePoints = routePoints;
    }

    public Route(long id, AppVersion appVersion, OsVersion osVersion, Device device, List<RoutePoint> routePoints) {
        this.id = id;
        this.appVersion = appVersion;
        this.osVersion = osVersion;
        this.device = device;
        this.routePoints = routePoints;
    }

    public Route(long id, AppVersion appVersion, OsVersion osVersion, Device device) {
        this.id = id;
        this.appVersion = appVersion;
        this.osVersion = osVersion;
        this.device = device;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public AppVersion getAppVersion() {
        return appVersion;
    }

    public void setAppVersion(AppVersion appVersion) {
        this.appVersion = appVersion;
    }

    public OsVersion getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(OsVersion osVersion) {
        this.osVersion = osVersion;
    }

    public Device getDevice() {
        return device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public List<RoutePoint> getRoutePoints() {
        return routePoints;
    }

    public void setRoutePoints(List<RoutePoint> routePoints) {
        this.routePoints = routePoints;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (RoutePoint routePoint : routePoints) {
            stringBuilder.append(routePoint.toString()).append(", ");
        }
        stringBuilder.append("]");

        return "Route{" +
                "id=" + id +
                ", appVersion=" + appVersion +
                ", osVersion=" + osVersion +
                ", device=" + device +
                ", routePoints=" + stringBuilder.toString() +
                '}';
    }
}
