package de.aipark.api.sdk;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.aipark.api.parkevent.ParkEventLiveLeavingIntern;
import de.aipark.api.sdk.route.Route;
import de.aipark.api.webservice.jsonConverter.aiparkapi.AiparkApiModule;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;
import rx.Observable;
import rx.schedulers.Schedulers;

import javax.net.ssl.SSLContext;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

/**
 * Created by torgen on 02.12.17.
 */
public class SdkApi implements SdkApiEndpointInterface {
    private SdkApiEndpointInterface sdkApiEndpointInterface;

    public SdkApi(String appApiUrl, final String appApiKey) {
        Retrofit retrofit;

        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JtsModule());
        objectMapper.registerModule(new AiparkApiModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

        try {
            OkHttpClient.Builder httpClient = new OkHttpClient.Builder().sslSocketFactory(createSSLContex().getSocketFactory());
            httpClient.addInterceptor(new Interceptor() {
                @Override
                public Response intercept(Chain chain) throws IOException {
                    Request original = chain.request();
                    Request request = original.newBuilder()
                            .header("User-Agent", "AIPARK")
                            .header("apikey", appApiKey)
                            .method(original.method(), original.body())
                            .build();
                    return chain.proceed(request);
                }
            });
            // logging
            /*HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
            interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            httpClient.addInterceptor(interceptor);*/

            retrofit = new Retrofit.Builder()
                    .client(httpClient.build())
                    .addCallAdapterFactory(RxJavaCallAdapterFactory.create())
                    .baseUrl(appApiUrl)
                    .addConverterFactory(JacksonConverterFactory.create(objectMapper))
                    .build();

            sdkApiEndpointInterface = retrofit.create(SdkApiEndpointInterface.class);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Observable<Long> addRoute(Route route) {
        Observable<Long> responseStream = sdkApiEndpointInterface.addRoute(route);
        return responseStream
                .subscribeOn(Schedulers.io());
    }

    @Override
    public Observable<Void> addLiveParkEvent(ParkEventLiveLeavingIntern parkEventLiveLeaving) {
        return sdkApiEndpointInterface.addLiveParkEvent(parkEventLiveLeaving);
    }

    public static SSLContext createSSLContex() throws NoSuchAlgorithmException, IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null,null,null);
        return sslContext;
    }
}
