package de.aipark.api.requestsResponse.getParkingAreasForTile;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.aipark.api.parkingarea.ParkingAreaDataFilter;
import de.aipark.api.requestsResponse.FiltersDeserializer;
import de.aipark.api.requestsResponse.Request;
import de.aipark.api.tile.Tile;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by torgen on 29.08.17.
 */
public class GetParkingAreasForTileRequest extends Request {
    @ApiModelProperty(value = "tile of parking areas", dataType = "de.aipark.api.tile.Tile", required = true)
    private Tile tile;

    @ApiModelProperty(value = "list of filters", dataType = "List<ParkingAreaDataFilter>", required = true)
    @JsonDeserialize(using = FiltersDeserializer.class)
    private List<ParkingAreaDataFilter> filters = new ArrayList<ParkingAreaDataFilter>();

    public GetParkingAreasForTileRequest(Tile tile, List<ParkingAreaDataFilter> filters) {
        this.tile = tile;
        this.filters = filters;
    }

    public GetParkingAreasForTileRequest() {

    }

    public Tile getTile() {
        return tile;
    }

    public void setTile(Tile tile) {
        this.tile = tile;
    }

    public List<ParkingAreaDataFilter> getFilters() {
        return filters;
    }

    public void setFilters(List<ParkingAreaDataFilter> filters) {
        this.filters = filters;
    }
}
