package de.aipark.api.requestsResponse.getParkingAreasForPosition;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.vividsolutions.jts.geom.Point;
import de.aipark.api.parkingarea.ParkingAreaDataFilter;
import de.aipark.api.requestsResponse.FiltersDeserializer;
import de.aipark.api.requestsResponse.Request;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by torgen on 27.09.17.
 */
public class GetParkingAreasForPositionRequest extends Request {
    @ApiModelProperty(value = "departurePosition of parking areas", required = true)
    private Point position;

    @ApiModelProperty(value = "number of parking areas", dataType = "java.lang.Integer", required = true, example = "10")
    private Integer numberOfParkingAreas;

    @ApiModelProperty(value = "list of filters", dataType = "List<ParkingAreaDataFilter>", required = true)
    @JsonDeserialize(using = FiltersDeserializer.class)
    private List<ParkingAreaDataFilter> filters = new ArrayList<ParkingAreaDataFilter>();

    public GetParkingAreasForPositionRequest() {
        filters = new ArrayList<ParkingAreaDataFilter>();
    }

    public GetParkingAreasForPositionRequest(Point position, Integer numberOfParkingAreas, List<ParkingAreaDataFilter> filters) {
        this.position = position;
        this.numberOfParkingAreas = numberOfParkingAreas;
        this.filters = filters;
    }

    public Point getPosition() {
        return position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public Integer getNumberOfParkingAreas() {
        return numberOfParkingAreas;
    }

    public void setNumberOfParkingAreas(Integer numberOfParkingAreas) {
        this.numberOfParkingAreas = numberOfParkingAreas;
    }

    public List<ParkingAreaDataFilter> getFilters() {
        return filters;
    }

    public void setFilters(List<ParkingAreaDataFilter> filters) {
        this.filters = filters;
    }
}
