package de.aipark.api.requestsResponse.getOccupancyForPosition;

import com.vividsolutions.jts.geom.Point;
import de.aipark.api.requestsResponse.Request;
import io.swagger.annotations.ApiModelProperty;

import java.sql.Timestamp;

/**
 * Created by torgen on 12.10.17.
 */
public class GetOccupancyForPositionRequest extends Request {
    @ApiModelProperty(value = "departurePosition for occupancy", required = true)
    private Point position;

    @ApiModelProperty(value = "timestamp for occupancy", dataType = "java.lang.Long", required = true, example = "1476561575000")
    private Timestamp timestamp;

    public GetOccupancyForPositionRequest() {
    }

    public GetOccupancyForPositionRequest(Point position, Timestamp timestamp) {
        this.position = position;
        this.timestamp = timestamp;
    }

    public Point getPosition() {
        return position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public Timestamp getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }
}
