package de.aipark.api.requestsResponse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.aipark.api.parkingarea.ParkingAreaDataFilter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Andreas on 01.01.18.
 */
public class FiltersDeserializer extends StdDeserializer<List<ParkingAreaDataFilter>> {

    public FiltersDeserializer() {
        super(List.class);
    }

    public List<ParkingAreaDataFilter> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {

        // check if field is {} (caused by kong-bug) or ["...", "..."] (normal behaviour)
        ObjectCodec oc = jp.getCodec();
        JsonNode node = oc.readTree(jp);
        if (node.isObject()) {
            return new ArrayList<ParkingAreaDataFilter>();
        } else {
            List<ParkingAreaDataFilter> filters = new ArrayList<ParkingAreaDataFilter>();
            for (final JsonNode content : node) {
                filters.add(ParkingAreaDataFilter.valueOf(content.toString().replace("\"","").replace("'","")));
            }
            return filters;
        }
    }
}
