package de.aipark.api.payment;

import io.swagger.annotations.ApiModelProperty;

import java.util.Currency;
import java.util.Locale;
import java.util.ResourceBundle;

/**
 * Created by torgen on 13.07.17.
 */
public class PriceModel {
    @ApiModelProperty(value = "start time in minutes", dataType = "java.lang.Integer", required = true, example = "60")
    private Integer fromMinute;

    @ApiModelProperty(value = "end time in minutes", dataType = "java.lang.Integer", required = true, example = "60")
    private Integer untilMinute;

    @ApiModelProperty(value = "interval time in minutes, e.g. 50 cent per 30 minutes", dataType = "java.lang.Integer", required = true, example = "30")
    private Integer interval;

    @ApiModelProperty(value = "price in cent", dataType = "java.lang.Integer", required = true, example = "50")
    private Integer priceInCent;

    @ApiModelProperty(value = "priority, e.g. one price model could dominate another", dataType = "java.lang.Integer", required = true, example = "50")
    private Integer priority;

    @ApiModelProperty(value = "textual description for special price models", dataType = "java.lang.String", required = true, example = "Tennisclub")
    private String description;

    @ApiModelProperty(value = "maximal price in cent", dataType = "java.lang.Integer", required = true, example = "50")
    private Integer maxPriceInCent;

    @ApiModelProperty(value = "currency", dataType = "java.lang.String", required = true, example = "EUR")
    private Currency currency;

    public PriceModel() {
        currency = Currency.getInstance("EUR");
    }

    public PriceModel(Integer fromMinute, Integer untilMinute, Integer interval, Integer priceInCent, Integer priority, String description, Integer maxPriceInCent, Currency currency) {
        this.fromMinute = fromMinute;
        this.untilMinute = untilMinute;
        this.interval = interval;
        this.priceInCent = priceInCent;
        this.priority = priority;
        this.description = description;
        this.maxPriceInCent = maxPriceInCent;
        this.currency = currency;
    }

    public Integer getFromMinute() {
        return fromMinute;
    }

    public void setFromMinute(Integer fromMinute) {
        this.fromMinute = fromMinute;
    }

    public Integer getUntilMinute() {
        return untilMinute;
    }

    public void setUntilMinute(Integer untilMinute) {
        this.untilMinute = untilMinute;
    }

    public Integer getInterval() {
        return interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public Integer getPriceInCent() {
        return priceInCent;
    }

    public void setPriceInCent(Integer priceInCent) {
        this.priceInCent = priceInCent;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getMaxPriceInCent() {
        return maxPriceInCent;
    }

    public void setMaxPriceInCent(Integer maxPriceInCent) {
        this.maxPriceInCent = maxPriceInCent;
    }

    public Currency getCurrency() {
        return currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PriceModel that = (PriceModel) o;

        if (fromMinute != null ? !fromMinute.equals(that.fromMinute) : that.fromMinute != null) return false;
        if (untilMinute != null ? !untilMinute.equals(that.untilMinute) : that.untilMinute != null) return false;
        if (interval != null ? !interval.equals(that.interval) : that.interval != null) return false;
        if (priceInCent != null ? !priceInCent.equals(that.priceInCent) : that.priceInCent != null) return false;
        if (priority != null ? !priority.equals(that.priority) : that.priority != null) return false;
        return description != null ? description.equals(that.description) : that.description == null;
    }

    @Override
    public int hashCode() {
        int result = fromMinute != null ? fromMinute.hashCode() : 0;
        result = 31 * result + (untilMinute != null ? untilMinute.hashCode() : 0);
        result = 31 * result + (interval != null ? interval.hashCode() : 0);
        result = 31 * result + (priceInCent != null ? priceInCent.hashCode() : 0);
        result = 31 * result + (priority != null ? priority.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        //don't copy the following line
        ResourceBundle bundle = ResourceBundle.getBundle( "Api" );


        //---- COPY CODE FROM HERE TO de.aipark.backend.modules.parser.parkingarea.scheduleparser.jsCompatible.PriceModel.priceModelToString() ------
        String result = "";
        if((priceInCent == null || priceInCent == -1) && maxPriceInCent == null){
            result += bundle.getString("withCosts");
        }
        else if(priceInCent != null && priceInCent != -1){
            result += getCurrencyAsString(priceInCent);
        }
        if(maxPriceInCent != null){
            result += bundle.getString("maximal") + " " + getCurrencyAsString(maxPriceInCent);
        }
        if(interval != null){
            result += bundle.getString("inIntervalOf") + " " + getTimeString(interval, bundle, true);
        }
        if(fromMinute != null && fromMinute > 0){
            if(untilMinute != null){
                result += " ";
            }
            else{
                result += " " + bundle.getString("from") + " ";
            }
            result += getTimeString(fromMinute, bundle, false);
        }
        if(untilMinute != null){
            result += " " + bundle.getString("until") + " " + getTimeString(untilMinute, bundle, false);
        }
        if(description != null){
            result += " " + description;
        }
        result = result.trim();

        return result;

        //---- COPY CODE UNTIL HERE TO de.aipark.backend.modules.parser.parkingarea.scheduleparser.jsCompatible.PriceModel.priceModelToString() ------
    }

    private String getTimeString(Integer minute, ResourceBundle bundle, boolean isInterval){
        int days = (int)Math.floor(minute / 60 / 24);
        int hours = minute / 60 % 24; //since both are ints, you get an int
        int minutes = minute % 60;

        String time = "";
        if(days > 0){
            if(days == 1){
                if(isInterval){
                    time = bundle.getString("day") + " ";
                }
                else{
                    time = bundle.getString("oneDay") + " ";
                }
            }
            else {
                time = days + " " + bundle.getString("days") + " ";
            }
        }
        if(hours > 0){
            String hourString = "";
            if(!time.isEmpty()){
                hourString += bundle.getString("and") + " ";
            }
            if(hours == 1){
                if(isInterval){
                    hourString += bundle.getString("hour") + " ";
                }
                else {
                    hourString += bundle.getString("oneHour") + " ";
                }
            }
            else {
                hourString += hours + " " + bundle.getString("hours") + " ";
            }
            time += hourString;
        }
        if(minutes > 0){
            String minuteString = "";
            if(!time.isEmpty()){
                minuteString += bundle.getString("and") + " ";
            }
            if(minutes == 1){
                if(isInterval){
                    minuteString += bundle.getString("minute") + " ";
                }
                else{
                    minuteString += bundle.getString("oneMinute") + " ";
                }
            }
            else {
                minuteString += minutes + " " + bundle.getString("minutes") + " ";
            }
            time += minuteString;
        }
        time = time.trim();
        return time;
    }

    /**
     * use {@link #getCurrencyAsString(Integer)} instead
     */
    //TODO: remove later
    @Deprecated
    protected String getCurrenceAsString(Integer priceInCent){
        return getCurrencyAsString(priceInCent);
    }

    protected String getCurrencyAsString(Integer priceInCent){
        int euro = priceInCent/100;
        int cent = priceInCent%100;
        String centString = "" + cent;
        if(cent < 10){
            centString = "0" + centString;
        }
        return euro + "," + centString + currency.getSymbol(Locale.getDefault()) + " ";
    }
}
