package de.aipark.api.parkingarea;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by torgen on 27.09.17.
 */
@SuppressWarnings("unused")
public class MapEntry<K, V> {
    private List<Entry<K, V>> entryList;

    public MapEntry() {
        entryList = new ArrayList<Entry<K, V>>();
    }


    /**
     * can be used when special SortedList is necessary, e.g. for Schedules because order is important for displaying
     */
    public MapEntry(List<Entry<K, V>> entryListInstance){
        this.entryList = entryListInstance;
    }

    public List<Entry<K, V>> getEntryList() {
        return entryList;
    }

    public void setEntryList(List<Entry<K, V>> entryList) {
        this.entryList = entryList;
    }

    public V findValueForKey(K key) {
        for (MapEntry.Entry<K, V> entry : entryList) {
            if (entry.getKey().equals(key)) {
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (!obj.getClass().equals(MapEntry.class)) {
            return false;
        }
        MapEntry other = (MapEntry) obj;
        List otherList = other.getEntryList();
        return this.getEntryList().containsAll(otherList) && otherList.containsAll(this.entryList);
    }

    @Override
    public int hashCode() {
        return entryList.hashCode();
    }

    @Override
    public String toString() {
        return "MapEntry{" +
                "entryList=" + entryList +
                '}';
    }

    static public class Entry<K, V> {
        private K key;
        private V value;

        public Entry() {
        }

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object obj) {
            if (!obj.getClass().equals(Entry.class)) {
                return false;
            }
            Entry other = (Entry) obj;
            if (!key.getClass().equals(other.getKey().getClass())) {
                return false;
            }
            if (!value.getClass().equals(other.getValue().getClass())) {
                return false;
            }
            return key.equals(other.getKey()) && value.equals(other.getValue());
        }

        @Override
        public int hashCode() {
            return (key + "" + value).hashCode();
        }

        @Override
        public String toString() {
            return "Entry{" +
                    "key=" + key +
                    ", value=" + value +
                    '}';
        }
    }
}
