package de.aipark.api.optimalTrip;

import com.vividsolutions.jts.geom.Point;
import de.aipark.api.occupancy.ParkingAreaWithOccupancy;
import de.aipark.api.parkingarea.ParkingAreaType;
import de.aipark.api.route.Route;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

/**
 * Created by torgen on 09.12.17.
 */
public class OptimalTrip {
    private List<Point> stopoverPoints;
    private List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip;
    private Route route;
    private Point destination;
    private boolean free;
    private boolean handicapped;
    private boolean resident;
    private double probability;
    private Integer parkingSpaces;
    private List<ParkingAreaType> preferredType;

    @ApiModelProperty(value = "estimated search duration for a parking spot in seconds")
    Integer estimatedSearchDuration;


    public OptimalTrip() {
        stopoverPoints = new ArrayList<Point>();
        parkingAreaResultsOptimalTrip = new ArrayList<ParkingAreaWithOccupancy>();
        free = false;
        handicapped = false;
        resident = false;
    }

    public OptimalTrip(List<Point> stopoverPoints, List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip, Route route, Point destination, boolean free, boolean handicapped, boolean resident, double probability, Integer parkingSpaces, List<ParkingAreaType> preferredType, Integer estimatedSearchDuration) {
        this.stopoverPoints = stopoverPoints;
        this.parkingAreaResultsOptimalTrip = parkingAreaResultsOptimalTrip;
        this.route = route;
        this.destination = destination;
        this.free = free;
        this.handicapped = handicapped;
        this.resident = resident;
        this.probability = probability;
        this.parkingSpaces = parkingSpaces;
        this.preferredType = preferredType;
        this.estimatedSearchDuration = estimatedSearchDuration;
    }

    public List<Point> getStopoverPoints() {
        return stopoverPoints;
    }

    public void setStopoverPoints(List<Point> stopoverPoints) {
        this.stopoverPoints = stopoverPoints;
    }

    public List<ParkingAreaWithOccupancy> getParkingAreaResultsOptimalTrip() {
        return parkingAreaResultsOptimalTrip;
    }

    public void setParkingAreaResultsOptimalTrip(List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip) {
        this.parkingAreaResultsOptimalTrip = parkingAreaResultsOptimalTrip;
    }

    public Route getRoute() {
        return route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public Point getDestination() {
        return destination;
    }

    public void setDestination(Point destination) {
        this.destination = destination;
    }

    public boolean isFree() {
        return free;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public boolean isHandicapped() {
        return handicapped;
    }

    public void setHandicapped(boolean handicapped) {
        this.handicapped = handicapped;
    }

    public boolean isResident() {
        return resident;
    }

    public void setResident(boolean resident) {
        this.resident = resident;
    }

    public double getProbability() {
        return probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public Integer getParkingSpaces() {
        return parkingSpaces;
    }

    public void setParkingSpaces(Integer parkingSpaces) {
        this.parkingSpaces = parkingSpaces;
    }

    public List<ParkingAreaType> getPreferredType() {
        return preferredType;
    }

    public void setPreferredType(List<ParkingAreaType> preferredType) {
        this.preferredType = preferredType;
    }

    public Integer getEstimatedSearchDuration() {
        return estimatedSearchDuration;
    }

    public void setEstimatedSearchDuration(Integer estimatedSearchDuration) {
        this.estimatedSearchDuration = estimatedSearchDuration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof OptimalTrip)) return false;

        OptimalTrip that = (OptimalTrip) o;

        if (isFree() != that.isFree()) return false;
        if (isHandicapped() != that.isHandicapped()) return false;
        if (isResident() != that.isResident()) return false;
        if (Double.compare(that.getProbability(), getProbability()) != 0) return false;
        if (getStopoverPoints() != null ? !getStopoverPoints().equals(that.getStopoverPoints()) : that.getStopoverPoints() != null)
            return false;
        if (getParkingAreaResultsOptimalTrip() != null ? !getParkingAreaResultsOptimalTrip().equals(that.getParkingAreaResultsOptimalTrip()) : that.getParkingAreaResultsOptimalTrip() != null)
            return false;
        if (getRoute() != null ? !getRoute().equals(that.getRoute()) : that.getRoute() != null) return false;
        if (getDestination() != null ? !getDestination().equals(that.getDestination()) : that.getDestination() != null)
            return false;
        if (getParkingSpaces() != null ? !getParkingSpaces().equals(that.getParkingSpaces()) : that.getParkingSpaces() != null)
            return false;
        if (getPreferredType() != null ? !getPreferredType().equals(that.getPreferredType()) : that.getPreferredType() != null)
            return false;
        return getEstimatedSearchDuration() != null ? getEstimatedSearchDuration().equals(that.getEstimatedSearchDuration()) : that.getEstimatedSearchDuration() == null;
    }

    @Override
    public int hashCode() {
        int result;
        long temp;
        result = getStopoverPoints() != null ? getStopoverPoints().hashCode() : 0;
        result = 31 * result + (getParkingAreaResultsOptimalTrip() != null ? getParkingAreaResultsOptimalTrip().hashCode() : 0);
        result = 31 * result + (getRoute() != null ? getRoute().hashCode() : 0);
        result = 31 * result + (getDestination() != null ? getDestination().hashCode() : 0);
        result = 31 * result + (isFree() ? 1 : 0);
        result = 31 * result + (isHandicapped() ? 1 : 0);
        result = 31 * result + (isResident() ? 1 : 0);
        temp = Double.doubleToLongBits(getProbability());
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        result = 31 * result + (getParkingSpaces() != null ? getParkingSpaces().hashCode() : 0);
        result = 31 * result + (getPreferredType() != null ? getPreferredType().hashCode() : 0);
        result = 31 * result + (getEstimatedSearchDuration() != null ? getEstimatedSearchDuration().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle( "Api" );
        String result = "";
        if(preferredType.size() > 0){
            switch (preferredType.get(0)){
                case CAR_PARK:
                    result += bundle.getString("preferCarParks");
                    break;
                case PARKINGAREA:
                case ON_STREET:
                    result += bundle.getString("preferFree");
                    break;
            }
        }

        return result;
    }
}
