package de.aipark.api.datasource;

import io.swagger.annotations.ApiModelProperty;

public class Datasource {

    private String type;
    private Integer priority,
            priorityName,
            priorityShape,
            priorityCapacity,
            priorityType,
            priorityCapacityWoman,
            priorityCapacityDisabled,
            priorityPrice,
            priorityClosed,
            priorityDisc,
            priorityResidential,
            priorityEntrance,
            priorityCharging;

    @ApiModelProperty(value = "license informations")
    private License license = null;

    @ApiModelProperty(value = "used for displaying datasource when it needs to be published due to license conditions", example = "Default Datasource")
    private String label = null;

    public Datasource(){

    }

    public Datasource(String type, Integer priority) {
        this.type = type;
        this.priority = priority;
        this.priorityName = priority;
        this.priorityShape = priority;
        this.priorityCapacity = priority;
        this.priorityType = priority;
        this.priorityCapacityWoman = priority;
        this.priorityCapacityDisabled = priority;
        this.priorityPrice = priority;
        this.priorityClosed = priority;
        this.priorityDisc = priority;
        this.priorityResidential = priority;
        this.priorityEntrance = priority;
        this.priorityCharging = priority;
    }

    public Datasource(String type) {
        this.type = type;
        this.priority = 0;
        this.priorityName = 0;
        this.priorityShape = 0;
        this.priorityCapacity = 0;
        this.priorityType = 0;
        this.priorityCapacityWoman = 0;
        this.priorityCapacityDisabled = 0;
        this.priorityPrice = 0;
        this.priorityClosed = 0;
        this.priorityDisc = 0;
        this.priorityResidential = 0;
        this.priorityEntrance = 0;
        this.priorityCharging = 0;
    }

    public Datasource(String type, Integer priority, Integer priorityName, Integer priorityShape, Integer priorityCapacity, Integer priorityType, Integer priorityCapacityWoman, Integer priorityCapacityDisabled, Integer priorityPrice, Integer priorityClosed, Integer priorityDisc, Integer priorityResidential, Integer priorityEntrance, Integer priorityCharging) {
        this.type = type;
        this.priority = priority;
        this.priorityName = priorityName;
        this.priorityShape = priorityShape;
        this.priorityCapacity = priorityCapacity;
        this.priorityType = priorityType;
        this.priorityCapacityWoman = priorityCapacityWoman;
        this.priorityCapacityDisabled = priorityCapacityDisabled;
        this.priorityPrice = priorityPrice;
        this.priorityClosed = priorityClosed;
        this.priorityDisc = priorityDisc;
        this.priorityResidential = priorityResidential;
        this.priorityEntrance = priorityEntrance;
        this.priorityCharging = priorityCharging;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriorityName() {
        return priorityName;
    }

    public void setPriorityName(Integer priorityName) {
        this.priorityName = priorityName;
    }

    public Integer getPriorityShape() {
        return priorityShape;
    }

    public void setPriorityShape(Integer priorityShape) {
        this.priorityShape = priorityShape;
    }

    public Integer getPriorityCapacity() {
        return priorityCapacity;
    }

    public void setPriorityCapacity(Integer priorityCapacity) {
        this.priorityCapacity = priorityCapacity;
    }

    public Integer getPriorityType() {
        return priorityType;
    }

    public void setPriorityType(Integer priorityType) {
        this.priorityType = priorityType;
    }

    public Integer getPriorityCapacityWoman() {
        return priorityCapacityWoman;
    }

    public void setPriorityCapacityWoman(Integer priorityCapacityWoman) {
        this.priorityCapacityWoman = priorityCapacityWoman;
    }

    public Integer getPriorityCapacityDisabled() {
        return priorityCapacityDisabled;
    }

    public void setPriorityCapacityDisabled(Integer priorityCapacityDisabled) {
        this.priorityCapacityDisabled = priorityCapacityDisabled;
    }

    public Integer getPriorityPrice() {
        return priorityPrice;
    }

    public void setPriorityPrice(Integer priorityPrice) {
        this.priorityPrice = priorityPrice;
    }

    public Integer getPriorityClosed() {
        return priorityClosed;
    }

    public void setPriorityClosed(Integer priorityClosed) {
        this.priorityClosed = priorityClosed;
    }

    public Integer getPriorityDisc() {
        return priorityDisc;
    }

    public void setPriorityDisc(Integer priorityDisc) {
        this.priorityDisc = priorityDisc;
    }

    public Integer getPriorityResidential() {
        return priorityResidential;
    }

    public void setPriorityResidential(Integer priorityResidential) {
        this.priorityResidential = priorityResidential;
    }

    public Integer getPriorityEntrance() {
        return priorityEntrance;
    }

    public void setPriorityEntrance(Integer priorityEntrance) {
        this.priorityEntrance = priorityEntrance;
    }

    public Integer getPriorityCharging() {
        return priorityCharging;
    }

    public void setPriorityCharging(Integer priorityCharging) {
        this.priorityCharging = priorityCharging;
    }

    public License getLicense() {
        return license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String toString() {
        return "Datasource{" +
                "type='" + type + '\'' +
                ", priority=" + priority +
                ", license=" + license +
                ", label='" + label + '\'' +
                '}';
    }
}
