package de.aipark.api.chargingstation;

import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by torgen on 11.02.18.
 */
public class ChargingStationFilter {
    private List<ChargingPlugType> plugTypes;

    @ApiModelProperty(value = "authentication filter for charging station", dataType = "[Ljava.lang.String;", allowableValues = "NFC, RFID")
    private List<String> authentications;

    public ChargingStationFilter() {
        plugTypes = new ArrayList<ChargingPlugType>();
        authentications = new ArrayList<String>();
    }

    public ChargingStationFilter(List<ChargingPlugType> plugTypes, List<String> authentications) {
        this.plugTypes = plugTypes;
        this.authentications = authentications;
    }

    public List<ChargingPlugType> getPlugTypes() {
        return plugTypes;
    }

    public void setPlugTypes(List<ChargingPlugType> plugTypes) {
        this.plugTypes = plugTypes;
    }

    public List<String> getAuthentications() {
        return authentications;
    }

    public void setAuthentications(List<String> authentications) {
        this.authentications = authentications;
    }

    @Override
    public String toString() {
        return "ChargingStationFilter{" +
                "plugTypes=" + plugTypes +
                ", authentications=" + authentications +
                '}';
    }
}
