package de.aipark.api.chargingstation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vividsolutions.jts.geom.Point;
import de.aipark.api.parkingarea.MapEntry;
import de.aipark.api.parkingarea.OpeningStatus;
import de.aipark.api.parkingarea.Schedule;
import de.aipark.api.payment.PaymentType;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

/**
 * Created by torgen on 05.02.18.
 */
public class ChargingStation {
    @ApiModelProperty(value = "unique id of charging station", dataType = "java.lang.Long", required = true, example = "504838")
    private Integer id;

    @ApiModelProperty(value = "unique id of parking area the charging station belongs to", dataType = "java.lang.Long", required = true, example = "504838")
    private Long parkingAreaId;

    @ApiModelProperty(value = "position of charging station", required = true)
    private Point position;

    @ApiModelProperty(value = "name of charging station", dataType = "java.lang.String", required = true, example = "City")
    private String name;

    @ApiModelProperty(value = "description of charging station", dataType = "java.lang.String", required = true, example = "Free charging station near to XY.")
    private String description;

    @ApiModelProperty(value = "unique id of charging station", dataType = "java.lang.Long", required = true, example = "504838")
    private Integer capacity;

    @ApiModelProperty(value = "operator of the charging station", required = true)
    private ChargingOperator operator;

    @ApiModelProperty(value = "charging plug types with capacity", required = true)
    private List<ChargingPlugTypeWithCapacity> plugTypes;

    @ApiModelProperty(value = "supported authentication types", required = true)
    private List<ChargingAuthentication> authentications;

    @ApiModelProperty(value = "pricing", required = true)
    private List<ChargingPriceEntry> priceEntries;

    @ApiModelProperty(value = "schedule when charging station is opened or closed", dataType = "MapEntry<Schedule, Boolean>", required = true)
    private MapEntry<Schedule, OpeningStatus> scheduleOpen;

    @ApiModelProperty(value = "schedule for charging station (value = allowed time in minutes)", dataType = "MapEntry<Schedule, Boolean>", required = true)
    private MapEntry<Schedule, Integer> scheduleMaxStay;

    @ApiModelProperty(value = "supported payment types", required = true)
    private List<PaymentType> paymentTypes;

    @ApiModelProperty(value = "website", dataType = "java.lang.String", required = true, example = "https://www.enercity.de/privatkunden/mobilitaet/e-mobilitaet/formular-reg-e-tanken/index.jsx")
    private String website;

    public ChargingStation() {
        plugTypes = new ArrayList<ChargingPlugTypeWithCapacity>();
        authentications = new ArrayList<ChargingAuthentication>();
        priceEntries = new ArrayList<ChargingPriceEntry>();
        scheduleOpen = new MapEntry<Schedule, OpeningStatus>();
        scheduleMaxStay = new MapEntry<Schedule, Integer>();
        paymentTypes = new ArrayList<PaymentType>();
    }

    public ChargingStation(Integer id, Long parkingAreaId, Point position, String name, String description, Integer capacity, ChargingOperator operator, List<ChargingPlugTypeWithCapacity> plugTypes, List<ChargingAuthentication> authentications, List<ChargingPriceEntry> priceEntries, MapEntry<Schedule, OpeningStatus> scheduleOpen, MapEntry<Schedule, Integer> scheduleMaxStay, List<PaymentType> paymentTypes, String website) {
        this.id = id;
        this.parkingAreaId = parkingAreaId;
        this.position = position;
        this.name = name;
        this.description = description;
        this.capacity = capacity;
        this.operator = operator;
        this.plugTypes = plugTypes;
        this.authentications = authentications;
        this.priceEntries = priceEntries;
        this.scheduleOpen = scheduleOpen;
        this.scheduleMaxStay = scheduleMaxStay;
        this.paymentTypes = paymentTypes;
        this.website = website;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Long getParkingAreaId() {
        return parkingAreaId;
    }

    public void setParkingAreaId(Long parkingAreaId) {
        this.parkingAreaId = parkingAreaId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getCapacity() {
        return capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public ChargingOperator getOperator() {
        return operator;
    }

    public void setOperator(ChargingOperator operator) {
        this.operator = operator;
    }

    public List<ChargingPlugTypeWithCapacity> getPlugTypes() {
        return plugTypes;
    }

    public void setPlugTypes(List<ChargingPlugTypeWithCapacity> plugTypes) {
        this.plugTypes = plugTypes;
    }

    public List<ChargingAuthentication> getAuthentications() {
        return authentications;
    }

    public void setAuthentications(List<ChargingAuthentication> authentications) {
        this.authentications = authentications;
    }

    public List<ChargingPriceEntry> getPriceEntries() {
        return priceEntries;
    }

    public void setPriceEntries(List<ChargingPriceEntry> priceEntries) {
        this.priceEntries = priceEntries;
    }

    public Point getPosition() {
        return position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public MapEntry<Schedule, OpeningStatus> getScheduleOpen() {
        return scheduleOpen;
    }

    public void setScheduleOpen(MapEntry<Schedule, OpeningStatus> scheduleOpen) {
        this.scheduleOpen = scheduleOpen;
    }

    public MapEntry<Schedule, Integer> getScheduleMaxStay() {
        return scheduleMaxStay;
    }

    public void setScheduleMaxStay(MapEntry<Schedule, Integer> scheduleMaxStay) {
        this.scheduleMaxStay = scheduleMaxStay;
    }

    public List<PaymentType> getPaymentTypes() {
        return paymentTypes;
    }

    public void setPaymentTypes(List<PaymentType> paymentTypes) {
        this.paymentTypes = paymentTypes;
    }

    public String getWebsite() {
        return website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ChargingStation)) return false;

        ChargingStation that = (ChargingStation) o;

        if (getId() != null ? !getId().equals(that.getId()) : that.getId() != null) return false;
        if (getParkingAreaId() != null ? !getParkingAreaId().equals(that.getParkingAreaId()) : that.getParkingAreaId() != null)
            return false;
        if (getPosition() != null ? !getPosition().equals(that.getPosition()) : that.getPosition() != null)
            return false;
        if (getName() != null ? !getName().equals(that.getName()) : that.getName() != null) return false;
        if (getDescription() != null ? !getDescription().equals(that.getDescription()) : that.getDescription() != null)
            return false;
        if (getCapacity() != null ? !getCapacity().equals(that.getCapacity()) : that.getCapacity() != null)
            return false;
        if (getOperator() != null ? !getOperator().equals(that.getOperator()) : that.getOperator() != null)
            return false;
        if (getPlugTypes() != null ? !getPlugTypes().equals(that.getPlugTypes()) : that.getPlugTypes() != null)
            return false;
        if (getAuthentications() != null ? !getAuthentications().equals(that.getAuthentications()) : that.getAuthentications() != null)
            return false;
        if (getPriceEntries() != null ? !getPriceEntries().equals(that.getPriceEntries()) : that.getPriceEntries() != null)
            return false;
        if (getScheduleOpen() != null ? !getScheduleOpen().equals(that.getScheduleOpen()) : that.getScheduleOpen() != null)
            return false;
        if (getScheduleMaxStay() != null ? !getScheduleMaxStay().equals(that.getScheduleMaxStay()) : that.getScheduleMaxStay() != null)
            return false;
        if (getPaymentTypes() != null ? !getPaymentTypes().equals(that.getPaymentTypes()) : that.getPaymentTypes() != null)
            return false;
        return getWebsite() != null ? getWebsite().equals(that.getWebsite()) : that.getWebsite() == null;
    }

    @Override
    public int hashCode() {
        int result = getId() != null ? getId().hashCode() : 0;
        result = 31 * result + (getParkingAreaId() != null ? getParkingAreaId().hashCode() : 0);
        result = 31 * result + (getPosition() != null ? getPosition().hashCode() : 0);
        result = 31 * result + (getName() != null ? getName().hashCode() : 0);
        result = 31 * result + (getDescription() != null ? getDescription().hashCode() : 0);
        result = 31 * result + (getCapacity() != null ? getCapacity().hashCode() : 0);
        result = 31 * result + (getOperator() != null ? getOperator().hashCode() : 0);
        result = 31 * result + (getPlugTypes() != null ? getPlugTypes().hashCode() : 0);
        result = 31 * result + (getAuthentications() != null ? getAuthentications().hashCode() : 0);
        result = 31 * result + (getPriceEntries() != null ? getPriceEntries().hashCode() : 0);
        result = 31 * result + (getScheduleOpen() != null ? getScheduleOpen().hashCode() : 0);
        result = 31 * result + (getScheduleMaxStay() != null ? getScheduleMaxStay().hashCode() : 0);
        result = 31 * result + (getPaymentTypes() != null ? getPaymentTypes().hashCode() : 0);
        result = 31 * result + (getWebsite() != null ? getWebsite().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        String result = "ChargingStation{" +
                "id=" + id +
                ", parkingAreaId=" + parkingAreaId +
                ", position=" + position +
                ", name='" + name + '\'' +
                ", description='" + description + '\'' +
                ", capacity=" + capacity +
                ", operator=" + operator +
                ", website='" + website + '\'' +
                '}';
        for(ChargingPlugTypeWithCapacity chargingPlugTypeWithCapacity : getPlugTypes()){
            result += "\n" + chargingPlugTypeWithCapacity;
        }
        for(ChargingAuthentication chargingAuthentication: getAuthentications()){
            result += "\n" + chargingAuthentication;
        }
        for(ChargingPriceEntry chargingPriceEntry: getPriceEntries()){
            result += "\n" + chargingPriceEntry;
        }
        for(MapEntry.Entry<Schedule,OpeningStatus> openingStatusEntry: getScheduleOpen().getEntryList()){
            result += "\n" + openingStatusEntry.getKey() + " : " + openingStatusEntry.getValue();
        }
        for(MapEntry.Entry<Schedule, Integer> maxStayEntry: getScheduleMaxStay().getEntryList()){
            result += "\n" + maxStayEntry.getKey() + " : " + maxStayEntry.getValue();
        }
        for(PaymentType paymentType: getPaymentTypes()){
            result += "\n" + paymentType;
        }
        return result;
    }

    @JsonIgnore
    public String getMaxStayString(){
        ResourceBundle bundle = ResourceBundle.getBundle( "Api" );
        String result = "";
        for(MapEntry.Entry<Schedule,Integer> entry: scheduleMaxStay.getEntryList()){
            if(!result.isEmpty()){
                result += "\n";
            }
            result += entry.getKey().toString() + " " + bundle.getString("maximal") + " " + entry.getValue() + " " +  bundle.getString("minutes");
        }
        return result;
    }
}
