/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.parkingarea;

import java.util.HashMap;
import java.util.Map;

public enum ParkingAreaType {
    CAR_PARK,
    UNDERGROUND_PARKING,
    UNDERGROUD_PARKING,
    AIRPORT,
    PARKINGAREA,
    ON_STREET,
    SPECIAL,
    PARK_AND_RIDE,
    PARKING_DECK_AUTOMATED,
    UNDERGROUND_PARKING_AUTOMATED,
    CUSTOMER_PARKING,
    PRIVATE;

    private static Map<String, ParkingAreaType> aliasMap;

    public static ParkingAreaType lookUpType(String type) {
        if (type == null) {
            return null;
        }
        if (aliasMap.containsKey(type.toUpperCase())) {
            return aliasMap.get(type.toUpperCase());
        }
        try {
            return ParkingAreaType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return ParkingAreaType.valueOf(type.split(",")[0].toUpperCase());
        }
    }

    public static ParkingAreaType getDefaultValue() {
        return PARKINGAREA;
    }

    static {
        aliasMap = new HashMap<String, ParkingAreaType>();
        aliasMap.put("TIEFGARAGE", UNDERGROUND_PARKING);
        aliasMap.put("PARKGARAGE", UNDERGROUND_PARKING);
        aliasMap.put("UNDERGROUD_PARKING", UNDERGROUND_PARKING);
        aliasMap.put("PARKHAUS", CAR_PARK);
        aliasMap.put("PARKDECK", CAR_PARK);
        aliasMap.put("PARKEN", CAR_PARK);
        aliasMap.put("CITY", CAR_PARK);
        aliasMap.put("PARKHAUS/PARKPLATZ", CAR_PARK);
        aliasMap.put("P+R", PARK_AND_RIDE);
        aliasMap.put("PARK & MITNEHMEN", PARKINGAREA);
        aliasMap.put("PARK & KISS", AIRPORT);
        aliasMap.put("PARK & FLY", AIRPORT);
        aliasMap.put("PARKPLATZ", PARKINGAREA);
        aliasMap.put("OFFENE FL\u00c4CHE", PARKINGAREA);
        aliasMap.put("AUTOMATISCHE TIEFGARAGE", UNDERGROUND_PARKING_AUTOMATED);
        aliasMap.put("AUTOMATISCHES PARKHAUS", PARKING_DECK_AUTOMATED);
        aliasMap.put("STRA\u00dfENPARKPLATZ", ON_STREET);
        aliasMap.put("STRASSENPARKPLATZ", ON_STREET);
        aliasMap.put("KUNDENPARKPLATZ", CUSTOMER_PARKING);
        aliasMap.put("PRIVAT", PRIVATE);
        aliasMap.put("FLUGHAFEN", AIRPORT);
    }
}

