/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.web;

import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import springfox.documentation.swagger2.web.ForwardedHeader;

public class HostNameProvider {
    public HostNameProvider() {
        throw new UnsupportedOperationException();
    }

    static UriComponents componentsFrom(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request);
        ForwardedHeader forwarded = ForwardedHeader.of(request.getHeader(ForwardedHeader.NAME));
        String proto = StringUtils.hasText(forwarded.getProto()) ? forwarded.getProto() : request.getHeader("X-Forwarded-Proto");
        String forwardedSsl = request.getHeader("X-Forwarded-Ssl");
        if (StringUtils.hasText(proto)) {
            builder.scheme(proto);
        } else if (StringUtils.hasText(forwardedSsl) && forwardedSsl.equalsIgnoreCase("on")) {
            builder.scheme("https");
        }
        String host = forwarded.getHost();
        String string = host = StringUtils.hasText(host) ? host : request.getHeader("X-Forwarded-Host");
        if (!StringUtils.hasText(host)) {
            return builder.build();
        }
        String[] hosts = StringUtils.commaDelimitedListToStringArray(host);
        String hostToUse = hosts[0];
        if (hostToUse.contains(":")) {
            String[] hostAndPort = StringUtils.split(hostToUse, ":");
            builder.host(hostAndPort[0]);
            builder.port(Integer.parseInt(hostAndPort[1]));
        } else {
            builder.host(hostToUse);
            builder.port(-1);
        }
        String port = request.getHeader("X-Forwarded-Port");
        if (StringUtils.hasText(port)) {
            builder.port(Integer.parseInt(port));
        }
        return builder.build();
    }
}

