/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ForwardedHeader {
    public static String NAME = "Forwarded";
    private static final ForwardedHeader NO_HEADER = new ForwardedHeader(Collections.<String, String>emptyMap());
    private final Map<String, String> elements;

    private ForwardedHeader(Map<String, String> elements) {
        this.elements = elements;
    }

    public static ForwardedHeader of(String source) {
        if (!StringUtils.hasText(source)) {
            return NO_HEADER;
        }
        HashMap<String, String> elements = new HashMap<String, String>();
        for (String part : source.split(";")) {
            String[] keyValue = part.split("=");
            if (keyValue.length != 2) continue;
            elements.put(keyValue[0].trim(), keyValue[1].trim());
        }
        Assert.notNull(elements, "Forwarded elements must not be null!");
        Assert.isTrue(!elements.isEmpty(), "At least one forwarded element needs to be present!");
        return new ForwardedHeader(elements);
    }

    public String getProto() {
        return this.elements.get("proto");
    }

    public String getHost() {
        return this.elements.get("host");
    }
}

