/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapstruct.Mapper;
import springfox.documentation.service.ObjectVendorExtension;
import springfox.documentation.service.StringVendorExtension;
import springfox.documentation.service.VendorExtension;

@Mapper
public class VendorExtensionsMapper {
    public Map<String, Object> mapExtensions(List<VendorExtension> from) {
        HashMap<String, Object> extensions = Maps.newHashMap();
        FluentIterable<Map<String, Object>> objectExtensions = FluentIterable.from(from).filter(ObjectVendorExtension.class).transform(this.toExtensionMap());
        for (Map map : objectExtensions) {
            extensions.putAll(map);
        }
        FluentIterable<StringVendorExtension> propertyExtensions = FluentIterable.from(from).filter(StringVendorExtension.class);
        for (StringVendorExtension each : propertyExtensions) {
            extensions.put(each.getName(), each.getValue());
        }
        return extensions;
    }

    private Function<ObjectVendorExtension, Map<String, Object>> toExtensionMap() {
        return new Function<ObjectVendorExtension, Map<String, Object>>(){

            @Override
            public Map<String, Object> apply(ObjectVendorExtension input) {
                if (!Strings.isNullOrEmpty(input.getName())) {
                    HashMap<String, Object> map = Maps.newHashMap();
                    map.put(input.getName(), VendorExtensionsMapper.this.mapExtensions((List<VendorExtension>)input.getValue()));
                    return map;
                }
                return VendorExtensionsMapper.this.propertiesAsMap(input);
            }
        };
    }

    private Map<String, Object> propertiesAsMap(ObjectVendorExtension input) {
        HashMap<String, Object> properties = Maps.newHashMap();
        FluentIterable<StringVendorExtension> stringExtensions = FluentIterable.from(input.getValue()).filter(StringVendorExtension.class);
        for (StringVendorExtension property : stringExtensions) {
            properties.put(property.getName(), property.getValue());
        }
        FluentIterable<ObjectVendorExtension> objectExtensions = FluentIterable.from(input.getValue()).filter(ObjectVendorExtension.class);
        for (ObjectVendorExtension property : objectExtensions) {
            properties.put(property.getName(), this.mapExtensions((List<VendorExtension>)property.getValue()));
        }
        return properties;
    }
}

