/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Operation;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.swagger2.mappers.LicenseMapper;
import springfox.documentation.swagger2.mappers.ModelMapper;
import springfox.documentation.swagger2.mappers.ParameterMapper;
import springfox.documentation.swagger2.mappers.SecurityMapper;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Component
public class ServiceModelToSwagger2MapperImpl
extends ServiceModelToSwagger2Mapper {
    @Autowired
    private ModelMapper modelMapper;
    @Autowired
    private ParameterMapper parameterMapper;
    @Autowired
    private SecurityMapper securityMapper;
    @Autowired
    private LicenseMapper licenseMapper;
    @Autowired
    private VendorExtensionsMapper vendorExtensionsMapper;

    @Override
    public Swagger mapDocumentation(Documentation from) {
        if (from == null) {
            return null;
        }
        Swagger swagger = new Swagger();
        swagger.setHost(from.getHost());
        swagger.setSchemes(this.mapSchemes(from.getSchemes()));
        swagger.setDefinitions(this.modelMapper.modelsFromApiListings(from.getApiListings()));
        swagger.setInfo(this.mapApiInfo(this.fromResourceListingInfo(from)));
        swagger.setPaths(this.mapApiListings(from.getApiListings()));
        swagger.setSecurityDefinitions(this.securityMapper.toSecuritySchemeDefinitions(from.getResourceListing()));
        swagger.setBasePath(from.getBasePath());
        swagger.setTags(this.tagSetToTagList(from.getTags()));
        if (from.getConsumes() != null) {
            swagger.setConsumes(new ArrayList<String>(from.getConsumes()));
        }
        if (from.getProduces() != null) {
            swagger.setProduces(new ArrayList<String>(from.getProduces()));
        }
        return swagger;
    }

    @Override
    protected Info mapApiInfo(ApiInfo from) {
        if (from == null) {
            return null;
        }
        Info info_ = new Info();
        info_.setTermsOfService(from.getTermsOfServiceUrl());
        info_.setLicense(this.licenseMapper.apiInfoToLicense(from));
        info_.setContact(this.map(from.getContact()));
        info_.setDescription(from.getDescription());
        info_.setVersion(from.getVersion());
        info_.setTitle(from.getTitle());
        return info_;
    }

    @Override
    protected Contact map(springfox.documentation.service.Contact from) {
        if (from == null) {
            return null;
        }
        Contact contact_ = new Contact();
        contact_.setName(from.getName());
        contact_.setUrl(from.getUrl());
        contact_.setEmail(from.getEmail());
        return contact_;
    }

    @Override
    protected io.swagger.models.Operation mapOperation(Operation from) {
        Map<String, Object> targetMap;
        if (from == null) {
            return null;
        }
        io.swagger.models.Operation operation = new io.swagger.models.Operation();
        if (operation.getVendorExtensions() != null && (targetMap = this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions())) != null) {
            operation.getVendorExtensions().putAll(targetMap);
        }
        operation.setSchemes(this.stringSetToSchemeList(from.getProtocol()));
        operation.setDescription(from.getNotes());
        operation.setSecurity(this.mapAuthorizations(from.getSecurityReferences()));
        operation.setResponses(this.mapResponseMessages(from.getResponseMessages()));
        operation.setOperationId(from.getUniqueId());
        if (from.getTags() != null) {
            operation.setTags(new ArrayList<String>(from.getTags()));
        }
        operation.setSummary(from.getSummary());
        if (from.getConsumes() != null) {
            operation.setConsumes(new ArrayList<String>(from.getConsumes()));
        }
        if (from.getProduces() != null) {
            operation.setProduces(new ArrayList<String>(from.getProduces()));
        }
        operation.setParameters(this.parameterListToParameterList(from.getParameters()));
        if (from.getDeprecated() != null) {
            operation.setDeprecated(Boolean.parseBoolean(from.getDeprecated()));
        }
        return operation;
    }

    @Override
    protected Tag mapTag(springfox.documentation.service.Tag from) {
        if (from == null) {
            return null;
        }
        Tag tag_ = new Tag();
        tag_.setName(from.getName());
        tag_.setDescription(from.getDescription());
        return tag_;
    }

    private ApiInfo fromResourceListingInfo(Documentation documentation) {
        if (documentation == null) {
            return null;
        }
        ResourceListing resourceListing = documentation.getResourceListing();
        if (resourceListing == null) {
            return null;
        }
        ApiInfo info = resourceListing.getInfo();
        if (info == null) {
            return null;
        }
        return info;
    }

    protected List<Tag> tagSetToTagList(Set<springfox.documentation.service.Tag> set) {
        if (set == null) {
            return null;
        }
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (springfox.documentation.service.Tag tag : set) {
            list.add(this.mapTag(tag));
        }
        return list;
    }

    protected List<Scheme> stringSetToSchemeList(Set<String> set) {
        if (set == null) {
            return null;
        }
        ArrayList<Scheme> list = new ArrayList<Scheme>();
        for (String string : set) {
            list.add(Enum.valueOf(Scheme.class, string));
        }
        return list;
    }

    protected List<Parameter> parameterListToParameterList(List<springfox.documentation.service.Parameter> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Parameter> list_ = new ArrayList<Parameter>();
        for (springfox.documentation.service.Parameter parameter : list) {
            list_.add(this.parameterMapper.mapParameter(parameter));
        }
        return list_;
    }
}

