/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.util.Map;
import org.mapstruct.Mapper;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.swagger2.mappers.ApiKeyAuthFactory;
import springfox.documentation.swagger2.mappers.BasicAuthFactory;
import springfox.documentation.swagger2.mappers.OAuth2AuthFactory;
import springfox.documentation.swagger2.mappers.SecuritySchemeFactory;

@Mapper
public class SecurityMapper {
    private Map<String, SecuritySchemeFactory> factories = ImmutableMap.builder().put("oauth2", new OAuth2AuthFactory()).put("apiKey", (OAuth2AuthFactory)((Object)new ApiKeyAuthFactory())).put("basicAuth", (OAuth2AuthFactory)((Object)new BasicAuthFactory())).build();

    public Map<String, SecuritySchemeDefinition> toSecuritySchemeDefinitions(ResourceListing from) {
        if (from == null) {
            return Maps.newHashMap();
        }
        return Maps.transformValues(Maps.uniqueIndex(from.getSecuritySchemes(), this.schemeName()), this.toSecuritySchemeDefinition());
    }

    private Function<SecurityScheme, String> schemeName() {
        return new Function<SecurityScheme, String>(){

            @Override
            public String apply(SecurityScheme input) {
                return input.getName();
            }
        };
    }

    private Function<SecurityScheme, SecuritySchemeDefinition> toSecuritySchemeDefinition() {
        return new Function<SecurityScheme, SecuritySchemeDefinition>(){

            @Override
            public SecuritySchemeDefinition apply(SecurityScheme input) {
                return ((SecuritySchemeFactory)SecurityMapper.this.factories.get(input.getType())).create(input);
            }
        };
    }
}

