/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.util.Comparator;
import java.util.Map;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Types;
import springfox.documentation.swagger2.mappers.EnumMapper;

class Properties {
    private static final Map<String, Function<String, ? extends Property>> typeFactory = ImmutableMap.builder().put("int", Properties.newInstanceOf(IntegerProperty.class)).put("long", Properties.newInstanceOf(LongProperty.class)).put("float", Properties.newInstanceOf(FloatProperty.class)).put("double", Properties.newInstanceOf(DoubleProperty.class)).put("string", Properties.newInstanceOf(StringProperty.class)).put("boolean", Properties.newInstanceOf(BooleanProperty.class)).put("date", Properties.newInstanceOf(DateProperty.class)).put("date-time", Properties.newInstanceOf(DateTimeProperty.class)).put("bigdecimal", Properties.newInstanceOf(DecimalProperty.class)).put("biginteger", Properties.newInstanceOf(BaseIntegerProperty.class)).put("uuid", Properties.newInstanceOf(UUIDProperty.class)).put("object", Properties.newInstanceOf(ObjectProperty.class)).put("byte", Properties.bytePropertyFactory()).put("file", Properties.filePropertyFactory()).build();

    private Properties() {
        throw new UnsupportedOperationException();
    }

    public static Property property(String typeName) {
        String safeTypeName = Strings.nullToEmpty(typeName);
        Function<String, Function<String, ? extends Property>> propertyLookup = Functions.forMap(typeFactory, Properties.voidOrRef(safeTypeName));
        return propertyLookup.apply(safeTypeName.toLowerCase()).apply(safeTypeName);
    }

    public static Property property(ModelReference modelRef) {
        if (modelRef.isMap()) {
            return new MapProperty(Properties.property(modelRef.itemModel().get()));
        }
        if (modelRef.isCollection()) {
            return new ArrayProperty(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty(modelRef.itemModel().get()), modelRef.getAllowableValues()));
        }
        return Properties.property(modelRef.getType());
    }

    public static Property itemTypeProperty(ModelReference paramModel) {
        if (paramModel.isCollection()) {
            return new ArrayProperty(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty(paramModel.itemModel().get()), paramModel.getAllowableValues()));
        }
        return Properties.property(paramModel.getType());
    }

    private static <T extends Property> Function<String, T> newInstanceOf(final Class<T> clazz) {
        return new Function<String, T>(){

            @Override
            public T apply(String input) {
                try {
                    return (Property)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    static Ordering<String> defaultOrdering(Map<String, ModelProperty> properties) {
        return Ordering.from(Properties.byPosition(properties)).compound(Properties.byName());
    }

    private static Function<String, ? extends Property> voidOrRef(final String typeName) {
        return new Function<String, Property>(){

            @Override
            public Property apply(String input) {
                if (typeName.equalsIgnoreCase("void")) {
                    return null;
                }
                return new RefProperty(typeName);
            }
        };
    }

    private static Function<String, ? extends Property> bytePropertyFactory() {
        return new Function<String, Property>(){

            @Override
            public Property apply(String input) {
                StringProperty byteArray = new StringProperty();
                byteArray.setFormat("byte");
                return byteArray;
            }
        };
    }

    private static Function<String, ? extends Property> filePropertyFactory() {
        return new Function<String, Property>(){

            @Override
            public Property apply(String input) {
                return new FileProperty();
            }
        };
    }

    private static Comparator<String> byName() {
        return new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                return first.compareTo(second);
            }
        };
    }

    private static Comparator<String> byPosition(final Map<String, ModelProperty> modelProperties) {
        return new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                ModelProperty p1 = (ModelProperty)modelProperties.get(first);
                ModelProperty p2 = (ModelProperty)modelProperties.get(second);
                return Ints.compare(p1.getPosition(), p2.getPosition());
            }
        };
    }

    static Predicate<Map.Entry<String, ModelProperty>> voidProperties() {
        return new Predicate<Map.Entry<String, ModelProperty>>(){

            @Override
            public boolean apply(Map.Entry<String, ModelProperty> input) {
                return Types.isVoid(input.getValue().getType()) || Properties.collectionOfVoid(input.getValue().getType()) || Properties.arrayTypeOfVoid(input.getValue().getType().getArrayElementType());
            }
        };
    }

    private static boolean arrayTypeOfVoid(ResolvedType arrayElementType) {
        return arrayElementType != null && Types.isVoid(arrayElementType);
    }

    private static boolean collectionOfVoid(ResolvedType type) {
        return Collections.isContainerType(type) && Types.isVoid(Collections.collectionElementType(type));
    }
}

