/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.mapstruct.Mapper;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.ApiListing;
import springfox.documentation.swagger2.mappers.EnumMapper;
import springfox.documentation.swagger2.mappers.Properties;

@Mapper
public abstract class ModelMapper {
    public Map<String, io.swagger.models.Model> mapModels(Map<String, Model> from) {
        if (from == null) {
            return null;
        }
        HashMap<String, io.swagger.models.Model> map = new HashMap<String, io.swagger.models.Model>();
        for (Map.Entry<String, Model> entry : from.entrySet()) {
            String key = entry.getKey();
            io.swagger.models.Model value = this.mapProperties(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    private io.swagger.models.Model mapProperties(Model source) {
        ModelImpl model = new ModelImpl().description(source.getDescription()).discriminator(source.getDiscriminator()).example(source.getExample()).name(source.getName());
        SortedMap<String, ModelProperty> sortedProperties = this.sort(source.getProperties());
        Map<String, Property> modelProperties = this.mapProperties(sortedProperties);
        model.setProperties(modelProperties);
        FluentIterable<String> requiredFields = FluentIterable.from(source.getProperties().values()).filter(this.requiredProperty()).transform(this.propertyName());
        model.setRequired(requiredFields.toList());
        model.setSimple(false);
        model.setType("object");
        if (springfox.documentation.schema.Maps.isMapType(source.getType())) {
            Optional<Class> clazz = this.typeOfValue(source);
            if (clazz.isPresent()) {
                model.additionalProperties(Properties.property(clazz.get().getSimpleName()));
            } else {
                model.additionalProperties(new ObjectProperty());
            }
        }
        return model;
    }

    private Map<String, Property> mapProperties(SortedMap<String, ModelProperty> properties) {
        LinkedHashMap<String, Property> mappedProperties = new LinkedHashMap<String, Property>();
        SortedMap<String, ModelProperty> nonVoidProperties = Maps.filterEntries(properties, Predicates.not(Properties.voidProperties()));
        for (Map.Entry<String, ModelProperty> propertyEntry : nonVoidProperties.entrySet()) {
            mappedProperties.put(propertyEntry.getKey(), this.mapProperty(propertyEntry.getValue()));
        }
        return mappedProperties;
    }

    private SortedMap<String, ModelProperty> sort(Map<String, ModelProperty> modelProperties) {
        TreeMap<String, ModelProperty> sortedMap = new TreeMap<String, ModelProperty>(Properties.defaultOrdering(modelProperties));
        sortedMap.putAll(modelProperties);
        return sortedMap;
    }

    @VisibleForTesting
    Optional<Class> typeOfValue(Model source) {
        Optional<ResolvedType> mapInterface = this.findMapInterface(source.getType());
        if (mapInterface.isPresent()) {
            return Optional.of(mapInterface.get().getTypeParameters().get(1).getErasedType());
        }
        return Optional.absent();
    }

    private Optional<ResolvedType> findMapInterface(ResolvedType type) {
        return Optional.fromNullable(type.findSupertype(Map.class));
    }

    private Property mapProperty(ModelProperty source) {
        AllowableRangeValues range;
        AllowableValues allowableValues;
        Property property = ModelMapper.modelRefToProperty(source.getModelRef());
        EnumMapper.maybeAddAllowableValues(property, source.getAllowableValues());
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            EnumMapper.maybeAddAllowableValues(arrayProperty.getItems(), source.getAllowableValues());
        }
        if (property instanceof AbstractNumericProperty && (allowableValues = source.getAllowableValues()) instanceof AllowableRangeValues) {
            range = (AllowableRangeValues)allowableValues;
            ((AbstractNumericProperty)property).maximum(EnumMapper.safeDouble(range.getMax()));
            ((AbstractNumericProperty)property).minimum(EnumMapper.safeDouble(range.getMin()));
        }
        if (property instanceof StringProperty) {
            allowableValues = source.getAllowableValues();
            if (allowableValues instanceof AllowableRangeValues) {
                range = (AllowableRangeValues)allowableValues;
                ((StringProperty)property).maxLength(ModelMapper.safeInteger(range.getMax()));
                ((StringProperty)property).minLength(ModelMapper.safeInteger(range.getMin()));
            }
            if (source.getPattern() != null) {
                ((StringProperty)property).setPattern(source.getPattern());
            }
        }
        if (property != null) {
            property.setDescription(source.getDescription());
            property.setName(source.getName());
            property.setRequired(source.isRequired());
            property.setReadOnly(source.isReadOnly());
            property.setExample(source.getExample());
        }
        return property;
    }

    static Integer safeInteger(String doubleString) {
        try {
            return Integer.valueOf(doubleString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static Property modelRefToProperty(ModelReference modelRef) {
        if (modelRef == null || "void".equalsIgnoreCase(modelRef.getType())) {
            return null;
        }
        Property responseProperty = modelRef.isCollection() ? new ArrayProperty(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty(modelRef.itemModel().get()), modelRef.getAllowableValues())) : (modelRef.isMap() ? new MapProperty(Properties.property(modelRef.itemModel().get())) : Properties.property(modelRef.getType()));
        EnumMapper.maybeAddAllowableValues(responseProperty, modelRef.getAllowableValues());
        return responseProperty;
    }

    Map<String, io.swagger.models.Model> modelsFromApiListings(Multimap<String, ApiListing> apiListings) {
        HashMap<String, Model> definitions = Maps.newHashMap();
        for (ApiListing each : apiListings.values()) {
            definitions.putAll(each.getModels());
        }
        return this.mapModels(definitions);
    }

    private Function<ModelProperty, String> propertyName() {
        return new Function<ModelProperty, String>(){

            @Override
            public String apply(ModelProperty input) {
                return input.getName();
            }
        };
    }

    private Predicate<ModelProperty> requiredProperty() {
        return new Predicate<ModelProperty>(){

            @Override
            public boolean apply(ModelProperty input) {
                return input.isRequired();
            }
        };
    }
}

