/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import io.swagger.models.ModelImpl;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.List;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;

public class EnumMapper {
    static ModelImpl maybeAddAllowableValuesToParameter(ModelImpl toReturn, AllowableValues allowableValues) {
        if (allowableValues instanceof AllowableListValues) {
            toReturn.setEnum(((AllowableListValues)allowableValues).getValues());
        }
        return toReturn;
    }

    static SerializableParameter maybeAddAllowableValuesToParameter(SerializableParameter toReturn, AllowableValues allowableValues) {
        if (allowableValues instanceof AllowableListValues) {
            toReturn.setEnum(((AllowableListValues)allowableValues).getValues());
        }
        if (allowableValues instanceof AllowableRangeValues) {
            toReturn.setMinimum(EnumMapper.safeDouble(((AllowableRangeValues)allowableValues).getMin()));
            toReturn.setMaximum(EnumMapper.safeDouble(((AllowableRangeValues)allowableValues).getMax()));
        }
        return toReturn;
    }

    static Double safeDouble(String doubleString) {
        try {
            return Double.valueOf(doubleString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static Property maybeAddAllowableValues(Property property, AllowableValues allowableValues) {
        if (allowableValues instanceof AllowableListValues) {
            AllowableListValues listValues;
            if (property instanceof StringProperty) {
                StringProperty stringProperty = (StringProperty)property;
                listValues = (AllowableListValues)allowableValues;
                stringProperty.setEnum(listValues.getValues());
            } else if (property instanceof IntegerProperty) {
                IntegerProperty integerProperty = (IntegerProperty)property;
                listValues = (AllowableListValues)allowableValues;
                integerProperty.setEnum(EnumMapper.convert(listValues.getValues(), Integer.class));
            } else if (property instanceof LongProperty) {
                LongProperty longProperty = (LongProperty)property;
                listValues = (AllowableListValues)allowableValues;
                longProperty.setEnum(EnumMapper.convert(listValues.getValues(), Long.class));
            } else if (property instanceof DoubleProperty) {
                DoubleProperty doubleProperty = (DoubleProperty)property;
                listValues = (AllowableListValues)allowableValues;
                doubleProperty.setEnum(EnumMapper.convert(listValues.getValues(), Double.class));
            } else if (property instanceof FloatProperty) {
                FloatProperty floatProperty = (FloatProperty)property;
                listValues = (AllowableListValues)allowableValues;
                floatProperty.setEnum(EnumMapper.convert(listValues.getValues(), Float.class));
            }
        }
        if (allowableValues instanceof AllowableRangeValues && property instanceof AbstractNumericProperty) {
            AbstractNumericProperty numeric = (AbstractNumericProperty)property;
            AllowableRangeValues range = (AllowableRangeValues)allowableValues;
            numeric.setMaximum(EnumMapper.safeDouble(range.getMax()));
            numeric.setMinimum(EnumMapper.safeDouble(range.getMin()));
        }
        return property;
    }

    private static <T extends Number> List<T> convert(List<String> values, Class<T> toType) {
        return Lists.newArrayList(Optional.presentInstances(FluentIterable.from(values).transform(EnumMapper.converterOfType(toType))));
    }

    private static <T extends Number> Function<? super String, Optional<T>> converterOfType(final Class<T> toType) {
        return new Function<String, Optional<T>>(){

            @Override
            public Optional<T> apply(String input) {
                try {
                    if (Integer.class.equals((Object)toType)) {
                        return Optional.of(Integer.valueOf(input));
                    }
                    if (Long.class.equals((Object)toType)) {
                        return Optional.of(Long.valueOf(input));
                    }
                    if (Double.class.equals((Object)toType)) {
                        return Optional.of(Double.valueOf(input));
                    }
                    if (Float.class.equals((Object)toType)) {
                        return Optional.of(Float.valueOf(input));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return Optional.absent();
            }
        };
    }
}

