/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class SwaggerApiListingReader
implements ApiListingBuilderPlugin {
    @Override
    public void apply(ApiListingContext apiListingContext) {
        Class<?> controllerClass = apiListingContext.getResourceGroup().getControllerClass();
        Optional<Api> apiAnnotation = Optional.fromNullable(AnnotationUtils.findAnnotation(controllerClass, Api.class));
        String description = Strings.emptyToNull(apiAnnotation.transform(this.descriptionExtractor()).orNull());
        Set tagSet = apiAnnotation.transform(this.tags()).or(Sets.newTreeSet());
        if (tagSet.isEmpty()) {
            tagSet.add(apiListingContext.getResourceGroup().getGroupName());
        }
        apiListingContext.apiListingBuilder().description(description).tagNames(tagSet);
    }

    private Function<Api, String> descriptionExtractor() {
        return new Function<Api, String>(){

            @Override
            public String apply(Api input) {
                return input.description();
            }
        };
    }

    private Function<Api, Set<String>> tags() {
        return new Function<Api, Set<String>>(){

            @Override
            public Set<String> apply(Api input) {
                return Sets.newTreeSet(FluentIterable.from(Lists.newArrayList(input.tags())).filter(Tags.emptyTags()).toSet());
            }
        };
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

