/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import com.google.common.base.Optional;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;
import springfox.documentation.swagger.web.UiConfiguration;

@Controller
@ApiIgnore
@RequestMapping(value={"/swagger-resources"})
public class ApiResourceController {
    @Autowired(required=false)
    private SecurityConfiguration securityConfiguration;
    @Autowired(required=false)
    private UiConfiguration uiConfiguration;
    private final SwaggerResourcesProvider swaggerResources;

    @Autowired
    public ApiResourceController(SwaggerResourcesProvider swaggerResources) {
        this.swaggerResources = swaggerResources;
    }

    @RequestMapping(value={"/configuration/security"})
    @ResponseBody
    ResponseEntity<SecurityConfiguration> securityConfiguration() {
        return new ResponseEntity((Object)Optional.fromNullable(this.securityConfiguration).or(SecurityConfiguration.DEFAULT), HttpStatus.OK);
    }

    @RequestMapping(value={"/configuration/ui"})
    @ResponseBody
    ResponseEntity<UiConfiguration> uiConfiguration() {
        return new ResponseEntity((Object)Optional.fromNullable(this.uiConfiguration).or(UiConfiguration.DEFAULT), HttpStatus.OK);
    }

    @RequestMapping
    @ResponseBody
    ResponseEntity<List<SwaggerResource>> swaggerResources() {
        return new ResponseEntity(this.swaggerResources.get(), HttpStatus.OK);
    }
}

