/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.schema;

import com.google.common.base.Optional;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Annotations;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component
@Order(value=-2147482648)
public class ApiModelPropertyPropertyBuilder
implements ModelPropertyBuilderPlugin {
    @Override
    public void apply(ModelPropertyContext context) {
        Optional<Object> annotation = Optional.absent();
        if (context.getAnnotatedElement().isPresent()) {
            annotation = annotation.or(ApiModelProperties.findApiModePropertyAnnotation(context.getAnnotatedElement().get()));
        }
        if (context.getBeanPropertyDefinition().isPresent()) {
            annotation = annotation.or(Annotations.findPropertyAnnotation(context.getBeanPropertyDefinition().get(), ApiModelProperty.class));
        }
        if (annotation.isPresent()) {
            context.getBuilder().allowableValues(annotation.transform(ApiModelProperties.toAllowableValues()).orNull()).required(annotation.transform(ApiModelProperties.toIsRequired()).or(false)).readOnly(annotation.transform(ApiModelProperties.toIsReadOnly()).or(false)).description(annotation.transform(ApiModelProperties.toDescription()).orNull()).isHidden(annotation.transform(ApiModelProperties.toHidden()).or(false)).type(annotation.transform(ApiModelProperties.toType(context.getResolver())).orNull()).position(annotation.transform(ApiModelProperties.toPosition()).or(0)).example(annotation.transform(ApiModelProperties.toExample()).orNull());
        }
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

