/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component
@Order(value=-2147482648)
public class SwaggerExpandedParameterBuilder
implements ExpandedParameterBuilderPlugin {
    @Override
    public void apply(ParameterExpansionContext context) {
        Optional<ApiParam> apiParamOptional;
        Optional<ApiModelProperty> apiModelPropertyOptional = ApiModelProperties.findApiModePropertyAnnotation((AnnotatedElement)context.getField().getRawMember());
        if (apiModelPropertyOptional.isPresent()) {
            this.fromApiModelProperty(context, apiModelPropertyOptional.get());
        }
        if ((apiParamOptional = Annotations.findApiParamAnnotation((AnnotatedElement)context.getField().getRawMember())).isPresent()) {
            this.fromApiParam(context, apiParamOptional.get());
        }
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private void fromApiParam(ParameterExpansionContext context, ApiParam apiParam) {
        String allowableProperty = Strings.emptyToNull(apiParam.allowableValues());
        AllowableValues allowable = this.allowableValues(Optional.fromNullable(allowableProperty), (Field)context.getField().getRawMember());
        context.getParameterBuilder().description(apiParam.value()).defaultValue(apiParam.defaultValue()).required(apiParam.required()).allowMultiple(apiParam.allowMultiple()).allowableValues(allowable).parameterAccess(apiParam.access()).hidden(apiParam.hidden()).build();
    }

    private void fromApiModelProperty(ParameterExpansionContext context, ApiModelProperty apiModelProperty) {
        String allowableProperty = Strings.emptyToNull(apiModelProperty.allowableValues());
        AllowableValues allowable = this.allowableValues(Optional.fromNullable(allowableProperty), (Field)context.getField().getRawMember());
        context.getParameterBuilder().description(apiModelProperty.value()).required(apiModelProperty.required()).allowableValues(allowable).parameterAccess(apiModelProperty.access()).hidden(apiModelProperty.hidden()).build();
    }

    private AllowableValues allowableValues(Optional<String> optionalAllowable, Field field) {
        AllowableValues allowable = null;
        if (field.getType().isEnum()) {
            allowable = new AllowableListValues(this.getEnumValues(field.getType()), "LIST");
        } else if (optionalAllowable.isPresent()) {
            allowable = ApiModelProperties.allowableValueFromString(optionalAllowable.get());
        }
        return allowable;
    }

    private List<String> getEnumValues(Class<?> subject) {
        return Lists.transform(Arrays.asList(subject.getEnumConstants()), new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                return input.toString();
            }
        });
    }
}

