/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.service.Header;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.readers.operation.ResponseMessagesReader;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.operation.ResponseHeaders;

@Component
@Order(value=-2147482648)
public class SwaggerResponseMessageReader
implements OperationBuilderPlugin {
    private final TypeNameExtractor typeNameExtractor;
    private final TypeResolver typeResolver;

    @Autowired
    public SwaggerResponseMessageReader(TypeNameExtractor typeNameExtractor, TypeResolver typeResolver) {
        this.typeNameExtractor = typeNameExtractor;
        this.typeResolver = typeResolver;
    }

    @Override
    public void apply(OperationContext context) {
        context.operationBuilder().responseMessages(this.read(context));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    protected Set<ResponseMessage> read(OperationContext context) {
        ResolvedType defaultResponse = context.getReturnType();
        Optional<ApiOperation> operationAnnotation = context.findAnnotation(ApiOperation.class);
        Optional<ResolvedType> operationResponse = operationAnnotation.transform(Annotations.resolvedTypeFromOperation(this.typeResolver, defaultResponse));
        Optional<ResponseHeader[]> defaultResponseHeaders = operationAnnotation.transform(ResponseHeaders.responseHeaders());
        HashMap<String, Header> defaultHeaders = Maps.newHashMap();
        if (defaultResponseHeaders.isPresent()) {
            defaultHeaders.putAll(ResponseHeaders.headers(defaultResponseHeaders.get()));
        }
        List<ApiResponses> allApiResponses = context.findAllAnnotations(ApiResponses.class);
        HashSet<ResponseMessage> responseMessages = Sets.newHashSet();
        HashMap<Integer, ApiResponse> seenResponsesByCode = Maps.newHashMap();
        for (ApiResponses apiResponses : allApiResponses) {
            ApiResponse[] apiResponseAnnotations;
            for (ApiResponse apiResponse : apiResponseAnnotations = apiResponses.value()) {
                if (seenResponsesByCode.containsKey(apiResponse.code())) continue;
                seenResponsesByCode.put(apiResponse.code(), apiResponse);
                ModelContext modelContext = ModelContext.returnValue(apiResponse.response(), context.getDocumentationType(), context.getAlternateTypeProvider(), context.getGenericsNamingStrategy(), context.getIgnorableParameterTypes());
                Optional<Object> responseModel = Optional.absent();
                Optional<ResolvedType> type = this.resolvedType(null, apiResponse);
                if (SwaggerResponseMessageReader.isSuccessful(apiResponse.code())) {
                    type = type.or(operationResponse);
                }
                if (type.isPresent()) {
                    responseModel = Optional.of(ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor).apply(context.alternateFor(type.get())));
                }
                HashMap<String, Header> headers = Maps.newHashMap(defaultHeaders);
                headers.putAll(ResponseHeaders.headers(apiResponse.responseHeaders()));
                responseMessages.add(new ResponseMessageBuilder().code(apiResponse.code()).message(apiResponse.message()).responseModel((ModelReference)responseModel.orNull()).headersWithDescription(headers).build());
            }
        }
        if (operationResponse.isPresent()) {
            ModelContext modelContext = ModelContext.returnValue(operationResponse.get(), context.getDocumentationType(), context.getAlternateTypeProvider(), context.getGenericsNamingStrategy(), context.getIgnorableParameterTypes());
            ResolvedType resolvedType = context.alternateFor(operationResponse.get());
            ModelReference responseModel = ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor).apply(resolvedType);
            context.operationBuilder().responseModel(responseModel);
            ResponseMessage defaultMessage = new ResponseMessageBuilder().code(ResponseMessagesReader.httpStatusCode(context)).message(ResponseMessagesReader.message(context)).responseModel(responseModel).build();
            if (!responseMessages.contains(defaultMessage) && !"void".equals(responseModel.getType())) {
                responseMessages.add(defaultMessage);
            }
        }
        return responseMessages;
    }

    static boolean isSuccessful(int code) {
        try {
            return HttpStatus.Series.SUCCESSFUL.equals((Object)HttpStatus.Series.valueOf((int)code));
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private Optional<ResolvedType> resolvedType(ResolvedType resolvedType, ApiResponse apiResponse) {
        return Optional.fromNullable(Annotations.resolvedTypeFromResponse(this.typeResolver, resolvedType).apply(apiResponse));
    }
}

