/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.ApiListingBuilder;
import springfox.documentation.schema.Model;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.paths.PathMappingAdjuster;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.scanners.ApiDescriptionReader;
import springfox.documentation.spring.web.scanners.ApiListingScanningContext;
import springfox.documentation.spring.web.scanners.ApiModelReader;

@Component
public class ApiListingScanner {
    private final ApiDescriptionReader apiDescriptionReader;
    private final ApiModelReader apiModelReader;
    private final DocumentationPluginsManager pluginsManager;

    @Autowired
    public ApiListingScanner(ApiDescriptionReader apiDescriptionReader, ApiModelReader apiModelReader, DocumentationPluginsManager pluginsManager) {
        this.apiDescriptionReader = apiDescriptionReader;
        this.apiModelReader = apiModelReader;
        this.pluginsManager = pluginsManager;
    }

    public Multimap<String, ApiListing> scan(ApiListingScanningContext context) {
        LinkedListMultimap<String, ApiListing> apiListingMap = LinkedListMultimap.create();
        int position = 0;
        Map<ResourceGroup, List<RequestMappingContext>> requestMappingsByResourceGroup = context.getRequestMappingsByResourceGroup();
        ArrayList<SecurityReference> securityReferences = Lists.newArrayList();
        for (ResourceGroup resourceGroup : this.sortedByName(requestMappingsByResourceGroup.keySet())) {
            DocumentationContext documentationContext = context.getDocumentationContext();
            LinkedHashSet<String> produces = new LinkedHashSet<String>(documentationContext.getProduces());
            LinkedHashSet<String> consumes = new LinkedHashSet<String>(documentationContext.getConsumes());
            String host = documentationContext.getHost();
            LinkedHashSet<String> protocols = new LinkedHashSet<String>(documentationContext.getProtocols());
            HashSet<ApiDescription> apiDescriptions = Sets.newHashSet();
            LinkedHashMap<String, Model> models = new LinkedHashMap<String, Model>();
            for (RequestMappingContext each : this.sortedByMethods(requestMappingsByResourceGroup.get(resourceGroup))) {
                models.putAll(this.apiModelReader.read(each.withKnownModels(models)));
                apiDescriptions.addAll(this.apiDescriptionReader.read(each));
            }
            apiDescriptions.addAll(this.pluginsManager.additionalListings(context));
            ArrayList<ApiDescription> sortedApis = Lists.newArrayList(apiDescriptions);
            Collections.sort(sortedApis, documentationContext.getApiDescriptionOrdering());
            String resourcePath = ApiListingScanner.longestCommonPath(sortedApis);
            PathProvider pathProvider = documentationContext.getPathProvider();
            String basePath = pathProvider.getApplicationBasePath();
            PathMappingAdjuster adjuster = new PathMappingAdjuster(documentationContext);
            ApiListingBuilder apiListingBuilder = new ApiListingBuilder(context.apiDescriptionOrdering()).apiVersion(documentationContext.getApiInfo().getVersion()).basePath(adjuster.adjustedPath(basePath)).resourcePath(resourcePath).produces(produces).consumes(consumes).host(host).protocols(protocols).securityReferences(securityReferences).apis(sortedApis).models(models).position(position++).availableTags(documentationContext.getTags());
            ApiListingContext apiListingContext = new ApiListingContext(context.getDocumentationType(), resourceGroup, apiListingBuilder);
            apiListingMap.put(resourceGroup.getGroupName(), this.pluginsManager.apiListing(apiListingContext));
        }
        return apiListingMap;
    }

    private Iterable<ResourceGroup> sortedByName(Set<ResourceGroup> resourceGroups) {
        return FluentIterable.from(resourceGroups).toSortedList(Orderings.resourceGroupComparator());
    }

    private Iterable<RequestMappingContext> sortedByMethods(List<RequestMappingContext> contexts) {
        return FluentIterable.from(contexts).toSortedList(Orderings.methodComparator());
    }

    static String longestCommonPath(List<ApiDescription> apiDescriptions) {
        ArrayList<String> commons = Lists.newArrayList();
        if (null == apiDescriptions || apiDescriptions.isEmpty()) {
            return null;
        }
        List<String> firstWords = ApiListingScanner.urlParts(apiDescriptions.get(0));
        for (int position = 0; position < firstWords.size(); ++position) {
            String word = firstWords.get(position);
            boolean allContain = true;
            for (int i = 1; i < apiDescriptions.size(); ++i) {
                List<String> words = ApiListingScanner.urlParts(apiDescriptions.get(i));
                if (words.size() >= position + 1 && words.get(position).equals(word)) continue;
                allContain = false;
                break;
            }
            if (!allContain) continue;
            commons.add(word);
        }
        Joiner joiner = Joiner.on("/").skipNulls();
        return "/" + joiner.join(commons);
    }

    static List<String> urlParts(ApiDescription apiDescription) {
        return Splitter.on('/').omitEmptyStrings().trimResults().splitToList(apiDescription.getPath());
    }
}

