/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterTypeReader
implements ParameterBuilderPlugin {
    @Override
    public void apply(ParameterContext context) {
        context.parameterBuilder().parameterType(ParameterTypeReader.findParameterType(context));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public static String findParameterType(ParameterContext parameterContext) {
        ResolvedMethodParameter resolvedMethodParameter = parameterContext.resolvedMethodParameter();
        ResolvedType parameterType = resolvedMethodParameter.getParameterType();
        if (MultipartFile.class.isAssignableFrom((parameterType = parameterContext.alternateFor(parameterType)).getErasedType())) {
            return "form";
        }
        if (resolvedMethodParameter.hasParameterAnnotation(PathVariable.class)) {
            return "path";
        }
        if (resolvedMethodParameter.hasParameterAnnotation(ModelAttribute.class)) {
            return ParameterTypeReader.queryOrForm(parameterContext.getOperationContext());
        }
        if (resolvedMethodParameter.hasParameterAnnotation(RequestBody.class)) {
            return "body";
        }
        if (resolvedMethodParameter.hasParameterAnnotation(RequestParam.class)) {
            return ParameterTypeReader.queryOrForm(parameterContext.getOperationContext());
        }
        if (resolvedMethodParameter.hasParameterAnnotation(RequestHeader.class)) {
            return "header";
        }
        if (resolvedMethodParameter.hasParameterAnnotation(RequestPart.class)) {
            return "form";
        }
        if (!resolvedMethodParameter.hasParameterAnnotations()) {
            return ParameterTypeReader.queryOrForm(parameterContext.getOperationContext());
        }
        return "body";
    }

    private static String queryOrForm(OperationContext context) {
        if (context.consumes().contains(MediaType.APPLICATION_FORM_URLENCODED) && context.httpMethod() == HttpMethod.POST) {
            return "form";
        }
        return "query";
    }
}

