/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.google.common.base.Optional;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterDefaultReader
implements ParameterBuilderPlugin {
    @Override
    public void apply(ParameterContext context) {
        String defaultValue = this.findAnnotatedDefaultValue(context.resolvedMethodParameter());
        boolean isSkip = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue);
        if (!isSkip) {
            context.parameterBuilder().defaultValue(defaultValue);
        }
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private String findAnnotatedDefaultValue(ResolvedMethodParameter methodParameter) {
        Optional<RequestParam> requestParam = methodParameter.findAnnotation(RequestParam.class);
        if (requestParam.isPresent()) {
            return requestParam.get().defaultValue();
        }
        Optional<RequestHeader> requestHeader = methodParameter.findAnnotation(RequestHeader.class);
        if (requestHeader.isPresent()) {
            return requestHeader.get().defaultValue();
        }
        return null;
    }
}

