/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Enums;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.Types;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;

@Component
@Order(value=-2147483648)
public class ExpandedParameterBuilder
implements ExpandedParameterBuilderPlugin {
    private final TypeResolver resolver;

    @Autowired
    public ExpandedParameterBuilder(TypeResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void apply(ParameterExpansionContext context) {
        AllowableValues allowable = this.allowableValues((Field)context.getField().getRawMember());
        String name = Strings.isNullOrEmpty(context.getParentName()) ? context.getField().getName() : String.format("%s.%s", context.getParentName(), context.getField().getName());
        String typeName = context.getDataTypeName();
        ModelRef itemModel = null;
        ResolvedType resolved = this.resolver.resolve(context.getField().getType(), new Type[0]);
        if (Collections.isContainerType(resolved)) {
            resolved = this.fieldType(context).or(resolved);
            ResolvedType elementType = Collections.collectionElementType(resolved);
            String itemTypeName = Types.typeNameFor(elementType.getErasedType());
            AllowableValues itemAllowables = null;
            if (elementType.getErasedType().isEnum()) {
                itemAllowables = Enums.allowableValues(elementType.getErasedType());
                itemTypeName = "string";
            }
            typeName = Collections.containerType(resolved);
            itemModel = new ModelRef(itemTypeName, itemAllowables);
        } else if (resolved.getErasedType().isEnum()) {
            typeName = "string";
        }
        context.getParameterBuilder().name(name).description(null).defaultValue(null).required(Boolean.FALSE).allowMultiple(Collections.isContainerType(resolved)).type(resolved).modelRef(new ModelRef(typeName, itemModel)).allowableValues(allowable).parameterType("query").parameterAccess(null);
    }

    private Optional<ResolvedType> fieldType(ParameterExpansionContext context) {
        return Optional.of(context.getField().getType());
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private AllowableValues allowableValues(Field field) {
        AllowableListValues allowable = null;
        if (field.getType().isEnum()) {
            allowable = new AllowableListValues(this.getEnumValues(field.getType()), "LIST");
        }
        return allowable;
    }

    private List<String> getEnumValues(Class<?> subject) {
        return Lists.transform(Arrays.asList(subject.getEnumConstants()), new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                return input.toString();
            }
        });
    }
}

