/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483648)
public class OperationResponseClassReader
implements OperationBuilderPlugin {
    private static Logger log = LoggerFactory.getLogger(OperationResponseClassReader.class);
    private final TypeResolver typeResolver;
    private final TypeNameExtractor nameExtractor;

    @Autowired
    public OperationResponseClassReader(TypeResolver typeResolver, TypeNameExtractor nameExtractor) {
        this.typeResolver = typeResolver;
        this.nameExtractor = nameExtractor;
    }

    @Override
    public void apply(OperationContext context) {
        ResolvedType returnType = context.getReturnType();
        returnType = context.alternateFor(returnType);
        ModelContext modelContext = ModelContext.returnValue(returnType, context.getDocumentationType(), context.getAlternateTypeProvider(), context.getGenericsNamingStrategy(), context.getIgnorableParameterTypes());
        String responseTypeName = this.nameExtractor.typeName(modelContext);
        log.debug("Setting spring response class to:" + responseTypeName);
        context.operationBuilder().responseModel(ResolvedTypes.modelRefFactory(modelContext, this.nameExtractor).apply(returnType));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

