/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ModelAttribute;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.Types;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.readers.parameter.ModelAttributeParameterExpander;

@Component
@Order(value=-2147483648)
public class OperationParameterReader
implements OperationBuilderPlugin {
    private final ModelAttributeParameterExpander expander;
    @Autowired
    private DocumentationPluginsManager pluginsManager;

    @Autowired
    public OperationParameterReader(ModelAttributeParameterExpander expander) {
        this.expander = expander;
    }

    @Override
    public void apply(OperationContext context) {
        context.operationBuilder().parameters(context.getGlobalOperationParameters());
        context.operationBuilder().parameters(this.readParameters(context));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private List<Parameter> readParameters(OperationContext context) {
        List<ResolvedMethodParameter> methodParameters = context.getParameters();
        ArrayList<Parameter> parameters = Lists.newArrayList();
        for (ResolvedMethodParameter methodParameter : methodParameters) {
            ResolvedType alternate;
            if (this.shouldIgnore(methodParameter, alternate = context.alternateFor(methodParameter.getParameterType()), context.getIgnorableParameterTypes())) continue;
            ParameterContext parameterContext = new ParameterContext(methodParameter, new ParameterBuilder(), context.getDocumentationContext(), context.getGenericsNamingStrategy(), context);
            if (this.shouldExpand(methodParameter, alternate)) {
                parameters.addAll(this.expander.expand("", methodParameter.getParameterType(), context.getDocumentationContext()));
                continue;
            }
            parameters.add(this.pluginsManager.parameter(parameterContext));
        }
        return FluentIterable.from(parameters).filter(Predicates.not(this.hiddenParams())).toList();
    }

    private Predicate<Parameter> hiddenParams() {
        return new Predicate<Parameter>(){

            @Override
            public boolean apply(Parameter input) {
                return input.isHidden();
            }
        };
    }

    private boolean shouldIgnore(ResolvedMethodParameter parameter, ResolvedType resolvedParameterType, Set<Class> ignorableParamTypes) {
        if (ignorableParamTypes.contains(resolvedParameterType.getErasedType())) {
            return true;
        }
        return FluentIterable.from(ignorableParamTypes).filter(this.isAnnotation()).filter(this.parameterIsAnnotatedWithIt(parameter)).size() > 0;
    }

    private Predicate<Class> parameterIsAnnotatedWithIt(final ResolvedMethodParameter parameter) {
        return new Predicate<Class>(){

            @Override
            public boolean apply(Class input) {
                return parameter.hasParameterAnnotation(input);
            }
        };
    }

    private Predicate<Class> isAnnotation() {
        return new Predicate<Class>(){

            @Override
            public boolean apply(Class input) {
                return Annotation.class.isAssignableFrom(input);
            }
        };
    }

    private boolean shouldExpand(ResolvedMethodParameter parameter, ResolvedType resolvedParamType) {
        return (!parameter.hasParameterAnnotations() || parameter.hasParameterAnnotation(ModelAttribute.class)) && !Types.isBaseType(Types.typeNameFor(resolvedParamType.getErasedType())) && !resolvedParamType.getErasedType().isEnum() && !Collections.isContainerType(resolvedParamType) && !Maps.isMapType(resolvedParamType);
    }
}

