/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.paths;

import org.springframework.web.util.UriComponentsBuilder;
import springfox.documentation.PathProvider;
import springfox.documentation.spring.web.paths.Paths;

public abstract class AbstractPathProvider
implements PathProvider {
    protected abstract String applicationPath();

    protected abstract String getDocumentationPath();

    @Override
    public String getApplicationBasePath() {
        return this.applicationPath();
    }

    @Override
    public String getOperationPath(String operationPath) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromPath((String)"/");
        return Paths.removeAdjacentForwardSlashes(uriComponentsBuilder.path(operationPath).build().toString());
    }

    @Override
    public String getResourceListingPath(String groupName, String apiDeclaration) {
        String candidate = this.agnosticUriComponentBuilder(this.getDocumentationPath()).pathSegment(new String[]{groupName, apiDeclaration}).build().toString();
        return Paths.removeAdjacentForwardSlashes(candidate);
    }

    private UriComponentsBuilder agnosticUriComponentBuilder(String url) {
        UriComponentsBuilder uriComponentsBuilder = url.startsWith("http") ? UriComponentsBuilder.fromHttpUrl((String)url) : UriComponentsBuilder.fromPath((String)url);
        return uriComponentsBuilder;
    }
}

