/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.web.ControllerNamingUtils;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

public class WebMvcRequestHandler
implements RequestHandler {
    private final RequestMappingInfo requestMapping;
    private final HandlerMethod handlerMethod;

    public WebMvcRequestHandler(RequestMappingInfo requestMapping, HandlerMethod handlerMethod) {
        this.requestMapping = requestMapping;
        this.handlerMethod = handlerMethod;
    }

    @Override
    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    @Override
    public RequestHandler combine(RequestHandler other) {
        return this;
    }

    @Override
    public Class<?> declaringClass() {
        return this.handlerMethod.getBeanType();
    }

    @Override
    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return null != AnnotationUtils.findAnnotation(this.handlerMethod.getMethod(), annotation);
    }

    @Override
    public PatternsRequestCondition getPatternsCondition() {
        return this.requestMapping.getPatternsCondition();
    }

    @Override
    public String groupName() {
        return ControllerNamingUtils.controllerNameAsGroup(this.handlerMethod);
    }

    @Override
    public String getName() {
        return this.handlerMethod.getMethod().getName();
    }

    @Override
    public Set<RequestMethod> supportedMethods() {
        return this.requestMapping.getMethodsCondition().getMethods();
    }

    @Override
    public Set<? extends MediaType> produces() {
        return this.requestMapping.getProducesCondition().getProducibleMediaTypes();
    }

    @Override
    public Set<? extends MediaType> consumes() {
        return this.requestMapping.getConsumesCondition().getConsumableMediaTypes();
    }

    @Override
    public Set<NameValueExpression<String>> headers() {
        return this.requestMapping.getHeadersCondition().getExpressions();
    }

    @Override
    public Set<NameValueExpression<String>> params() {
        return this.requestMapping.getParamsCondition().getExpressions();
    }

    @Override
    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return Optional.fromNullable(AnnotationUtils.findAnnotation(this.handlerMethod.getMethod(), annotation));
    }

    @Override
    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.requestMapping.getPatternsCondition().getPatterns(), this.requestMapping.getMethodsCondition().getMethods(), this.requestMapping.getConsumesCondition().getConsumableMediaTypes(), this.requestMapping.getProducesCondition().getProducibleMediaTypes());
    }

    @Override
    public List<ResolvedMethodParameter> getParameters() {
        HandlerMethodResolver handlerMethodResolver = new HandlerMethodResolver(new TypeResolver());
        return handlerMethodResolver.methodParameters(this.handlerMethod);
    }

    @Override
    public ResolvedType getReturnType() {
        HandlerMethodResolver handlerMethodResolver = new HandlerMethodResolver(new TypeResolver());
        return handlerMethodResolver.methodReturnType(this.handlerMethod);
    }

    @Override
    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return Optional.fromNullable(AnnotationUtils.findAnnotation(this.handlerMethod.getBeanType(), annotation));
    }

    @Override
    public RequestMappingInfo getRequestMapping() {
        return this.requestMapping;
    }
}

