/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.google.common.collect.Sets;
import java.util.Set;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ResourceGroupingStrategy;
import springfox.documentation.spring.web.paths.Paths;

public class SpringGroupingStrategy
implements ResourceGroupingStrategy {
    @Override
    public Set<ResourceGroup> getResourceGroups(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return this.groups(handlerMethod);
    }

    @Override
    public String getResourceDescription(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return this.getDescription(handlerMethod.getBeanType());
    }

    @Override
    public Integer getResourcePosition(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return 0;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private Set<ResourceGroup> groups(HandlerMethod handlerMethod) {
        Class controllerClazz = handlerMethod.getBeanType();
        String controllerAsGroup = Paths.splitCamelCase(controllerClazz.getSimpleName(), "-").toLowerCase();
        return Sets.newHashSet(new ResourceGroup(controllerAsGroup, controllerClazz));
    }

    private String getDescription(Class<?> controllerClass) {
        return Paths.splitCamelCase(controllerClass.getSimpleName(), " ");
    }
}

