/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Tag;

public class Tags {
    private Tags() {
        throw new UnsupportedOperationException();
    }

    public static Set<Tag> toTags(Multimap<String, ApiListing> apiListings) {
        Iterable<ApiListing> allListings = Iterables.concat(BuilderDefaults.nullToEmptyMultimap(apiListings).asMap().values());
        ImmutableList<Tag> tags = FluentIterable.from(allListings).transformAndConcat(Tags.collectTags()).toList();
        TreeSet<Tag> tagSet = Sets.newTreeSet(Tags.tagNameComparator());
        tagSet.addAll(tags);
        return tagSet;
    }

    public static Comparator<Tag> tagNameComparator() {
        return new Comparator<Tag>(){

            @Override
            public int compare(Tag first, Tag second) {
                return first.getName().compareTo(second.getName());
            }
        };
    }

    public static Function<String, Tag> toTag(final Function<String, String> descriptor) {
        return new Function<String, Tag>(){

            @Override
            public Tag apply(String input) {
                return new Tag(input, (String)descriptor.apply(input));
            }
        };
    }

    public static Function<String, String> descriptor(final Map<String, Tag> tagLookup, final String defaultDescription) {
        return new Function<String, String>(){

            @Override
            public String apply(String input) {
                return Optional.fromNullable(tagLookup.get(input)).transform(Tags.toTagDescription()).or(defaultDescription);
            }
        };
    }

    private static Function<Tag, String> toTagDescription() {
        return new Function<Tag, String>(){

            @Override
            public String apply(Tag input) {
                return input.getDescription();
            }
        };
    }

    public static Function<Tag, String> toTagName() {
        return new Function<Tag, String>(){

            @Override
            public String apply(Tag input) {
                return input.getName();
            }
        };
    }

    static Function<ApiListing, Iterable<Tag>> collectTags() {
        return new Function<ApiListing, Iterable<Tag>>(){

            @Override
            public Iterable<Tag> apply(ApiListing input) {
                return input.getTags();
            }
        };
    }

    public static Predicate<String> emptyTags() {
        return new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return !Strings.isNullOrEmpty(input);
            }
        };
    }
}

