/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class MediaTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTypes.class);

    private MediaTypes() {
        throw new UnsupportedOperationException();
    }

    public static Set<MediaType> toMediaTypes(Set<String> consumes) {
        return FluentIterable.from(consumes).transform(MediaTypes.parsedMediaType()).filter(Predicates.notNull()).toSet();
    }

    private static Function<String, MediaType> parsedMediaType() {
        return new Function<String, MediaType>(){

            @Override
            public MediaType apply(String input) {
                try {
                    return MediaType.valueOf((String)input);
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Unable to parse media type %s", input));
                    return null;
                }
            }
        };
    }
}

