/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.classmate.members.ResolvedParameterizedMember;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ModelPropertyBuilder;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.BeanPropertyDefinitions;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;
import springfox.documentation.schema.property.FactoryMethodProvider;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.schema.property.SimpleMethodSignatureEquality;
import springfox.documentation.schema.property.bean.AccessorsProvider;
import springfox.documentation.schema.property.bean.BeanModelProperty;
import springfox.documentation.schema.property.bean.ParameterModelProperty;
import springfox.documentation.schema.property.field.FieldModelProperty;
import springfox.documentation.schema.property.field.FieldProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Primary
@Component(value="optimized")
public class OptimizedModelPropertiesProvider
implements ModelPropertiesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizedModelPropertiesProvider.class);
    private final AccessorsProvider accessors;
    private final FieldProvider fields;
    private final FactoryMethodProvider factoryMethods;
    private final TypeResolver typeResolver;
    private final BeanPropertyNamingStrategy namingStrategy;
    private final SchemaPluginsManager schemaPluginsManager;
    private final TypeNameExtractor typeNameExtractor;
    private ObjectMapper objectMapper;

    @Autowired
    public OptimizedModelPropertiesProvider(AccessorsProvider accessors, FieldProvider fields, FactoryMethodProvider factoryMethods, TypeResolver typeResolver, BeanPropertyNamingStrategy namingStrategy, SchemaPluginsManager schemaPluginsManager, TypeNameExtractor typeNameExtractor) {
        this.accessors = accessors;
        this.fields = fields;
        this.factoryMethods = factoryMethods;
        this.typeResolver = typeResolver;
        this.namingStrategy = namingStrategy;
        this.schemaPluginsManager = schemaPluginsManager;
        this.typeNameExtractor = typeNameExtractor;
    }

    @Override
    public void onApplicationEvent(ObjectMapperConfigured event) {
        this.objectMapper = event.getObjectMapper();
    }

    @Override
    public List<ModelProperty> propertiesFor(ResolvedType type, ModelContext givenContext) {
        ArrayList<ModelProperty> properties = Lists.newArrayList();
        BeanDescription beanDescription = this.beanDescription(type, givenContext);
        ImmutableMap<String, BeanPropertyDefinition> propertyLookup = Maps.uniqueIndex(beanDescription.findProperties(), BeanPropertyDefinitions.beanPropertyByInternalName());
        for (Map.Entry each : propertyLookup.entrySet()) {
            LOG.debug("Reading property {}", each.getKey());
            BeanPropertyDefinition jacksonProperty = (BeanPropertyDefinition)each.getValue();
            Optional<AnnotatedMember> annotatedMember = Optional.fromNullable(this.safeGetPrimaryMember(jacksonProperty));
            if (!annotatedMember.isPresent()) continue;
            properties.addAll(this.candidateProperties(type, annotatedMember.get(), jacksonProperty, givenContext));
        }
        return FluentIterable.from(properties).toSortedSet(this.byPropertyName()).asList();
    }

    private Comparator<ModelProperty> byPropertyName() {
        return new Comparator<ModelProperty>(){

            @Override
            public int compare(ModelProperty first, ModelProperty second) {
                return first.getName().compareTo(second.getName());
            }
        };
    }

    private AnnotatedMember safeGetPrimaryMember(BeanPropertyDefinition jacksonProperty) {
        try {
            return jacksonProperty.getPrimaryMember();
        }
        catch (IllegalArgumentException e) {
            LOG.warn(String.format("Unable to get unique property. %s", e.getMessage()));
            return null;
        }
    }

    private Function<ResolvedMethod, List<ModelProperty>> propertyFromBean(final ModelContext givenContext, final BeanPropertyDefinition jacksonProperty) {
        return new Function<ResolvedMethod, List<ModelProperty>>(){

            @Override
            public List<ModelProperty> apply(ResolvedMethod input) {
                ResolvedType type = BeanModelProperty.paramOrReturnType(OptimizedModelPropertiesProvider.this.typeResolver, input);
                if (!givenContext.canIgnore(type)) {
                    if (OptimizedModelPropertiesProvider.this.shouldUnwrap(input)) {
                        return OptimizedModelPropertiesProvider.this.propertiesFor(type, ModelContext.fromParent(givenContext, type));
                    }
                    return Lists.newArrayList(OptimizedModelPropertiesProvider.this.beanModelProperty(input, jacksonProperty, givenContext));
                }
                return Lists.newArrayList();
            }
        };
    }

    private boolean shouldUnwrap(ResolvedMethod input) {
        return Iterables.any(Lists.newArrayList(((Method)input.getRawMember()).getDeclaredAnnotations()), this.ofType(JsonUnwrapped.class));
    }

    private Function<ResolvedField, List<ModelProperty>> propertyFromField(final ModelContext givenContext, final BeanPropertyDefinition jacksonProperty) {
        return new Function<ResolvedField, List<ModelProperty>>(){

            @Override
            public List<ModelProperty> apply(ResolvedField input) {
                ArrayList<Annotation> annotations = Lists.newArrayList(((Field)input.getRawMember()).getAnnotations());
                if (!givenContext.canIgnore(input.getType())) {
                    if (Iterables.any(annotations, OptimizedModelPropertiesProvider.this.ofType(JsonUnwrapped.class))) {
                        return OptimizedModelPropertiesProvider.this.propertiesFor(input.getType(), ModelContext.fromParent(givenContext, input.getType()));
                    }
                    return Lists.newArrayList(OptimizedModelPropertiesProvider.this.fieldModelProperty(input, jacksonProperty, givenContext));
                }
                return Lists.newArrayList();
            }
        };
    }

    private Predicate<? super Annotation> ofType(final Class<?> annotationType) {
        return new Predicate<Annotation>(){

            @Override
            public boolean apply(Annotation input) {
                return annotationType.isAssignableFrom(input.getClass());
            }
        };
    }

    @VisibleForTesting
    List<ModelProperty> candidateProperties(ResolvedType type, AnnotatedMember member, BeanPropertyDefinition jacksonProperty, ModelContext givenContext) {
        ArrayList<ModelProperty> properties = Lists.newArrayList();
        if (member instanceof AnnotatedMethod) {
            properties.addAll(this.findAccessorMethod(type, member).transform(this.propertyFromBean(givenContext, jacksonProperty)).or(new ArrayList()));
        } else if (member instanceof AnnotatedField) {
            properties.addAll(this.findField(type, jacksonProperty.getInternalName()).transform(this.propertyFromField(givenContext, jacksonProperty)).or(new ArrayList()));
        } else if (member instanceof AnnotatedParameter) {
            ModelContext modelContext = ModelContext.fromParent(givenContext, type);
            properties.addAll(this.fromFactoryMethod(type, jacksonProperty, (AnnotatedParameter)member, modelContext));
        }
        return FluentIterable.from(properties).filter(this.hiddenProperties()).toList();
    }

    private Predicate<? super ModelProperty> hiddenProperties() {
        return new Predicate<ModelProperty>(){

            @Override
            public boolean apply(ModelProperty input) {
                return !input.isHidden();
            }
        };
    }

    private Optional<ResolvedField> findField(ResolvedType resolvedType, final String fieldName) {
        return Iterables.tryFind(this.fields.in(resolvedType), new Predicate<ResolvedField>(){

            @Override
            public boolean apply(ResolvedField input) {
                return fieldName.equals(input.getName());
            }
        });
    }

    private ModelProperty fieldModelProperty(ResolvedField childField, BeanPropertyDefinition jacksonProperty, ModelContext modelContext) {
        String fieldName = BeanPropertyDefinitions.name(jacksonProperty, modelContext.isReturnType(), this.namingStrategy);
        FieldModelProperty fieldModelProperty = new FieldModelProperty(fieldName, childField, this.typeResolver, modelContext.getAlternateTypeProvider(), jacksonProperty);
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(fieldModelProperty.getName()).type(fieldModelProperty.getType()).qualifiedType(fieldModelProperty.qualifiedTypeName()).position(fieldModelProperty.position()).required(fieldModelProperty.isRequired()).description(fieldModelProperty.propertyDescription()).allowableValues(fieldModelProperty.allowableValues()).example(fieldModelProperty.example());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, (AnnotatedElement)childField.getRawMember(), this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor));
    }

    private ModelProperty beanModelProperty(ResolvedMethod childProperty, BeanPropertyDefinition jacksonProperty, ModelContext modelContext) {
        String propertyName = BeanPropertyDefinitions.name(jacksonProperty, modelContext.isReturnType(), this.namingStrategy);
        BeanModelProperty beanModelProperty = new BeanModelProperty(propertyName, childProperty, this.typeResolver, modelContext.getAlternateTypeProvider(), jacksonProperty);
        LOG.debug("Adding property {} to model", (Object)propertyName);
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(beanModelProperty.getName()).type(beanModelProperty.getType()).qualifiedType(beanModelProperty.qualifiedTypeName()).position(beanModelProperty.position()).required(beanModelProperty.isRequired()).isHidden(false).description(beanModelProperty.propertyDescription()).allowableValues(beanModelProperty.allowableValues()).example(beanModelProperty.example());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, jacksonProperty, this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor));
    }

    private ModelProperty paramModelProperty(ResolvedParameterizedMember constructor, BeanPropertyDefinition jacksonProperty, AnnotatedParameter parameter, ModelContext modelContext) {
        String propertyName = BeanPropertyDefinitions.name(jacksonProperty, modelContext.isReturnType(), this.namingStrategy);
        ParameterModelProperty parameterModelProperty = new ParameterModelProperty(propertyName, parameter, constructor, this.typeResolver, modelContext.getAlternateTypeProvider(), jacksonProperty);
        LOG.debug("Adding property {} to model", (Object)propertyName);
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(parameterModelProperty.getName()).type(parameterModelProperty.getType()).qualifiedType(parameterModelProperty.qualifiedTypeName()).position(parameterModelProperty.position()).required(parameterModelProperty.isRequired()).isHidden(false).description(parameterModelProperty.propertyDescription()).allowableValues(parameterModelProperty.allowableValues()).example(parameterModelProperty.example());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, jacksonProperty, this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor));
    }

    private Optional<ResolvedMethod> findAccessorMethod(ResolvedType resolvedType, final AnnotatedMember member) {
        return Iterables.tryFind(this.accessors.in(resolvedType), new Predicate<ResolvedMethod>(){

            @Override
            public boolean apply(ResolvedMethod accessorMethod) {
                SimpleMethodSignatureEquality methodComparer = new SimpleMethodSignatureEquality();
                return methodComparer.equivalent(accessorMethod.getRawMember(), (Method)member.getMember());
            }
        });
    }

    private List<ModelProperty> fromFactoryMethod(ResolvedType resolvedType, final BeanPropertyDefinition beanProperty, final AnnotatedParameter member, final ModelContext givenContext) {
        Optional<ModelProperty> property = this.factoryMethods.in(resolvedType, FactoryMethodProvider.factoryMethodOf(member)).transform(new Function<ResolvedParameterizedMember, ModelProperty>(){

            @Override
            public ModelProperty apply(ResolvedParameterizedMember input) {
                return OptimizedModelPropertiesProvider.this.paramModelProperty(input, beanProperty, member, givenContext);
            }
        });
        if (property.isPresent()) {
            return Lists.newArrayList(property.get());
        }
        return Lists.newArrayList();
    }

    private BeanDescription beanDescription(ResolvedType type, ModelContext context) {
        if (context.isReturnType()) {
            SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
            return serializationConfig.introspect(TypeFactory.defaultInstance().constructType(type.getErasedType()));
        }
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        return serializationConfig.introspect(TypeFactory.defaultInstance().constructType(type.getErasedType()));
    }
}

