/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.base.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.property.BeanPropertyDefinitions;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;

@Component
public class ObjectMapperBeanPropertyNamingStrategy
implements BeanPropertyNamingStrategy,
ApplicationListener<ObjectMapperConfigured> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectMapperBeanPropertyNamingStrategy.class);
    private ObjectMapper objectMapper;

    @Override
    public String nameForSerialization(BeanPropertyDefinition beanProperty) {
        SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
        Optional<PropertyNamingStrategy> namingStrategy = Optional.fromNullable(serializationConfig.getPropertyNamingStrategy());
        String newName = namingStrategy.transform(BeanPropertyDefinitions.overTheWireName(beanProperty, serializationConfig)).or(beanProperty.getName());
        LOG.debug("Name '{}' renamed to '{}'", (Object)beanProperty.getName(), (Object)newName);
        return newName;
    }

    @Override
    public String nameForDeserialization(BeanPropertyDefinition beanProperty) {
        DeserializationConfig deserializationConfig = this.objectMapper.getDeserializationConfig();
        Optional<PropertyNamingStrategy> namingStrategy = Optional.fromNullable(deserializationConfig.getPropertyNamingStrategy());
        String newName = namingStrategy.transform(BeanPropertyDefinitions.overTheWireName(beanProperty, deserializationConfig)).or(beanProperty.getName());
        LOG.debug("Name '{}' renamed to '{}'", (Object)beanProperty.getName(), (Object)newName);
        return newName;
    }

    @Override
    public void onApplicationEvent(ObjectMapperConfigured event) {
        this.objectMapper = event.getObjectMapper();
    }
}

