/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.google.common.base.Function;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;
import springfox.documentation.schema.property.PojoPropertyBuilderFactory;

public class BeanPropertyDefinitions {
    private BeanPropertyDefinitions() {
        throw new UnsupportedOperationException();
    }

    public static Function<BeanPropertyDefinition, String> beanPropertyByInternalName() {
        return new Function<BeanPropertyDefinition, String>(){

            @Override
            public String apply(BeanPropertyDefinition input) {
                return input.getInternalName();
            }
        };
    }

    public static String name(BeanPropertyDefinition beanPropertyDefinition, boolean forSerialization, BeanPropertyNamingStrategy namingStrategy) {
        return forSerialization ? namingStrategy.nameForSerialization(beanPropertyDefinition) : namingStrategy.nameForDeserialization(beanPropertyDefinition);
    }

    public static Function<PropertyNamingStrategy, String> overTheWireName(final BeanPropertyDefinition beanProperty, final MapperConfig<?> config) {
        return new Function<PropertyNamingStrategy, String>(){

            @Override
            public String apply(PropertyNamingStrategy strategy) {
                return BeanPropertyDefinitions.getName(strategy, beanProperty, config);
            }
        };
    }

    private static String getName(PropertyNamingStrategy naming, BeanPropertyDefinition beanProperty, MapperConfig<?> config) {
        PojoPropertyBuilderFactory factory = new PojoPropertyBuilderFactory();
        POJOPropertyBuilder prop = factory.create(config, beanProperty);
        return naming.nameForField(config, prop.getField(), beanProperty.getName());
    }
}

