/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.spi.schema.contexts.ModelContext;

class ModelReferenceProvider
implements Function<ResolvedType, ModelReference> {
    private final TypeNameExtractor typeNameExtractor;
    private final ModelContext parentContext;

    public ModelReferenceProvider(TypeNameExtractor typeNameExtractor, ModelContext parentContext) {
        this.typeNameExtractor = typeNameExtractor;
        this.parentContext = parentContext;
    }

    @Override
    public ModelReference apply(ResolvedType type) {
        return this.collectionReference(type).or(this.mapReference(type)).or(this.modelReference(type));
    }

    private ModelReference modelReference(ResolvedType type) {
        if (Void.class.equals(type.getErasedType()) || Void.TYPE.equals(type.getErasedType())) {
            return new ModelRef("void");
        }
        if (MultipartFile.class.isAssignableFrom(type.getErasedType())) {
            return new ModelRef("File");
        }
        String typeName = this.typeNameExtractor.typeName(ModelContext.fromParent(this.parentContext, type));
        return new ModelRef(typeName, ResolvedTypes.allowableValues(type));
    }

    private Optional<ModelReference> mapReference(ResolvedType type) {
        if (Maps.isMapType(type)) {
            ResolvedType mapValueType = Maps.mapValueType(type);
            String typeName = this.typeNameExtractor.typeName(ModelContext.fromParent(this.parentContext, type));
            return Optional.of(new ModelRef(typeName, this.apply(mapValueType), true));
        }
        return Optional.absent();
    }

    private Optional<ModelReference> collectionReference(ResolvedType type) {
        if (Collections.isContainerType(type)) {
            ResolvedType collectionElementType = Collections.collectionElementType(type);
            String typeName = this.typeNameExtractor.typeName(ModelContext.fromParent(this.parentContext, type));
            return Optional.of(new ModelRef(typeName, this.apply(collectionElementType), ResolvedTypes.allowableValues(collectionElementType)));
        }
        return Optional.absent();
    }
}

