/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;

public class Enums {
    private Enums() {
        throw new UnsupportedOperationException();
    }

    public static AllowableValues allowableValues(Class<?> type) {
        if (type.isEnum()) {
            List<String> enumValues = Enums.getEnumValues(type);
            return new AllowableListValues(enumValues, "LIST");
        }
        return null;
    }

    static List<String> getEnumValues(Class<?> subject) {
        return Enums.transformUnique(subject.getEnumConstants(), new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                Optional jsonValue = Enums.findJsonValueAnnotatedMethod(input).transform(Enums.evaluateJsonValue(input));
                if (jsonValue.isPresent() && !Strings.isNullOrEmpty((String)jsonValue.get())) {
                    return (String)jsonValue.get();
                }
                return input.toString();
            }
        });
    }

    private static Function<Method, String> evaluateJsonValue(final Object enumConstant) {
        return new Function<Method, String>(){

            @Override
            public String apply(Method input) {
                try {
                    return input.invoke(enumConstant, new Object[0]).toString();
                }
                catch (Exception exception) {
                    return "";
                }
            }
        };
    }

    private static <E> List<String> transformUnique(E[] values, Function<E, String> mapper) {
        List<String> nonUniqueValues = Lists.transform(Arrays.asList(values), mapper);
        LinkedHashSet<String> uniqueValues = new LinkedHashSet<String>(nonUniqueValues);
        return new ArrayList<String>(uniqueValues);
    }

    private static Optional<Method> findJsonValueAnnotatedMethod(Object enumConstant) {
        for (Method each : enumConstant.getClass().getMethods()) {
            JsonValue jsonValue = AnnotationUtils.findAnnotation(each, JsonValue.class);
            if (jsonValue == null || !jsonValue.value()) continue;
            return Optional.of(each);
        }
        return Optional.absent();
    }

    public static AllowableValues emptyListValuesToNull(AllowableListValues values) {
        if (!values.getValues().isEmpty()) {
            return values;
        }
        return null;
    }
}

