/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelDependencyProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="cachedModelDependencies")
public class CachingModelDependencyProvider
implements ModelDependencyProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingModelDependencyProvider.class);
    private final LoadingCache<ModelContext, Set<ResolvedType>> cache;

    @Autowired
    public CachingModelDependencyProvider(final @Qualifier(value="default") ModelDependencyProvider delegate) {
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(24L, TimeUnit.HOURS).build(new CacheLoader<ModelContext, Set<ResolvedType>>(){

            @Override
            public Set<ResolvedType> load(ModelContext key) {
                return delegate.dependentModels(key);
            }
        });
    }

    @Override
    public Set<ResolvedType> dependentModels(ModelContext modelContext) {
        try {
            return this.cache.get(modelContext);
        }
        catch (Exception e) {
            LOGGER.warn("Exception calculating dependencies for model -> {}, {}", (Object)modelContext.description(), (Object)e.getMessage());
            return Sets.newHashSet();
        }
    }
}

